/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.invocation.InvocationsFinder;
import com.appland.shade.org.mockito.internal.verification.VerificationModeFactory;
import com.appland.shade.org.mockito.internal.verification.api.VerificationData;
import com.appland.shade.org.mockito.internal.verification.api.VerificationDataInOrder;
import com.appland.shade.org.mockito.internal.verification.api.VerificationInOrderMode;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.verification.VerificationMode;
import java.util.List;

public class NoMoreInteractions
implements VerificationMode,
VerificationInOrderMode {
    @Override
    public void verify(VerificationData data) {
        Invocation unverified = InvocationsFinder.findFirstUnverified(data.getAllInvocations());
        if (unverified != null) {
            throw Reporter.noMoreInteractionsWanted(unverified, data.getAllInvocations());
        }
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> invocations = data.getAllInvocations();
        Invocation unverified = InvocationsFinder.findFirstUnverifiedInOrder(data.getOrderingContext(), invocations);
        if (unverified != null) {
            throw Reporter.noMoreInteractionsWantedInOrder(unverified);
        }
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

