/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification;

import com.appland.shade.org.mockito.exceptions.base.MockitoException;
import com.appland.shade.org.mockito.internal.verification.VerificationModeFactory;
import com.appland.shade.org.mockito.internal.verification.api.VerificationData;
import com.appland.shade.org.mockito.internal.verification.api.VerificationDataInOrder;
import com.appland.shade.org.mockito.internal.verification.api.VerificationInOrderMode;
import com.appland.shade.org.mockito.internal.verification.checkers.MissingInvocationChecker;
import com.appland.shade.org.mockito.internal.verification.checkers.NumberOfInvocationsChecker;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import com.appland.shade.org.mockito.verification.VerificationMode;
import java.util.List;

public class Times
implements VerificationInOrderMode,
VerificationMode {
    final int wantedCount;

    public Times(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        List<Invocation> invocations = data.getAllInvocations();
        MatchableInvocation wanted = data.getTarget();
        if (this.wantedCount > 0) {
            MissingInvocationChecker.checkMissingInvocation(data.getAllInvocations(), data.getTarget());
        }
        NumberOfInvocationsChecker.checkNumberOfInvocations(invocations, wanted, this.wantedCount);
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> allInvocations = data.getAllInvocations();
        MatchableInvocation wanted = data.getWanted();
        if (this.wantedCount > 0) {
            MissingInvocationChecker.checkMissingInvocation(allInvocations, wanted, data.getOrderingContext());
        }
        NumberOfInvocationsChecker.checkNumberOfInvocations(allInvocations, wanted, this.wantedCount, data.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count: " + this.wantedCount;
    }

    @Override
    public VerificationMode description(String description) {
        return VerificationModeFactory.description(this, description);
    }
}

