/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.invocation.InvocationMatcher;
import com.appland.shade.org.mockito.internal.stubbing.InvocationContainerImpl;
import com.appland.shade.org.mockito.internal.util.ObjectMethodsGuru;
import com.appland.shade.org.mockito.internal.verification.api.VerificationData;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import java.util.List;

public class VerificationDataImpl
implements VerificationData {
    private final InvocationMatcher wanted;
    private final InvocationContainerImpl invocations;

    public VerificationDataImpl(InvocationContainerImpl invocations, InvocationMatcher wanted) {
        this.invocations = invocations;
        this.wanted = wanted;
        this.assertWantedIsVerifiable();
    }

    @Override
    public List<Invocation> getAllInvocations() {
        return this.invocations.getInvocations();
    }

    @Override
    public MatchableInvocation getTarget() {
        return this.wanted;
    }

    @Override
    public InvocationMatcher getWanted() {
        return this.wanted;
    }

    private void assertWantedIsVerifiable() {
        if (this.wanted == null) {
            return;
        }
        if (ObjectMethodsGuru.isToStringMethod(this.wanted.getMethod())) {
            throw Reporter.cannotVerifyToString();
        }
    }
}

