/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification.checkers;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.invocation.InvocationMarker;
import com.appland.shade.org.mockito.internal.invocation.InvocationsFinder;
import com.appland.shade.org.mockito.internal.verification.api.InOrderContext;
import com.appland.shade.org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.Location;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import java.util.List;

public class AtLeastXNumberOfInvocationsChecker {
    public static void checkAtLeastNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount) {
        List<Invocation> actualInvocations = InvocationsFinder.findInvocations(invocations, wanted);
        int actualCount = actualInvocations.size();
        if (wantedCount > actualCount) {
            List<Location> allLocations = InvocationsFinder.getAllLocations(actualInvocations);
            throw Reporter.tooFewActualInvocations(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, allLocations);
        }
        InvocationMarker.markVerified(actualInvocations, wanted);
    }

    public static void checkAtLeastNumberOfInvocations(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext orderingContext) {
        List<Invocation> chunk = InvocationsFinder.findAllMatchingUnverifiedChunks(invocations, wanted, orderingContext);
        int actualCount = chunk.size();
        if (wantedCount > actualCount) {
            List<Location> allLocations = InvocationsFinder.getAllLocations(chunk);
            throw Reporter.tooFewActualInvocationsInOrder(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, allLocations);
        }
        InvocationMarker.markVerifiedInOrder(chunk, wanted, orderingContext);
    }
}

