/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.mockito.internal.verification.checkers;

import com.appland.shade.org.mockito.internal.exceptions.Reporter;
import com.appland.shade.org.mockito.internal.invocation.InvocationsFinder;
import com.appland.shade.org.mockito.internal.reporting.SmartPrinter;
import com.appland.shade.org.mockito.internal.util.collections.ListUtil;
import com.appland.shade.org.mockito.internal.verification.api.InOrderContext;
import com.appland.shade.org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import com.appland.shade.org.mockito.invocation.Invocation;
import com.appland.shade.org.mockito.invocation.Location;
import com.appland.shade.org.mockito.invocation.MatchableInvocation;
import java.util.LinkedList;
import java.util.List;

public class MissingInvocationChecker {
    private MissingInvocationChecker() {
    }

    public static void checkMissingInvocation(List<Invocation> invocations, MatchableInvocation wanted) {
        List<Invocation> actualInvocations = InvocationsFinder.findInvocations(invocations, wanted);
        if (!actualInvocations.isEmpty()) {
            return;
        }
        Invocation similar = InvocationsFinder.findSimilarInvocation(invocations, wanted);
        if (similar == null) {
            throw Reporter.wantedButNotInvoked(wanted, invocations);
        }
        Integer[] indexesOfSuspiciousArgs = ArgumentMatchingTool.getSuspiciouslyNotMatchingArgsIndexes(wanted.getMatchers(), similar.getArguments());
        SmartPrinter smartPrinter = new SmartPrinter(wanted, invocations, indexesOfSuspiciousArgs);
        LinkedList<Location> actualLocations = ListUtil.convert(invocations, new ListUtil.Converter<Invocation, Location>(){

            @Override
            public Location convert(Invocation invocation) {
                return invocation.getLocation();
            }
        });
        throw Reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActuals(), actualLocations);
    }

    public static void checkMissingInvocation(List<Invocation> invocations, MatchableInvocation wanted, InOrderContext context) {
        List<Invocation> chunk = InvocationsFinder.findAllMatchingUnverifiedChunks(invocations, wanted, context);
        if (!chunk.isEmpty()) {
            return;
        }
        Invocation previousInOrder = InvocationsFinder.findPreviousVerifiedInOrder(invocations, context);
        if (previousInOrder != null) {
            throw Reporter.wantedButNotInvokedInOrder(wanted, previousInOrder);
        }
        MissingInvocationChecker.checkMissingInvocation(invocations, wanted);
    }
}

