/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.ClientIdentity;
import java.util.Objects;
import javax.annotation.Nullable;

public class ClientCertificate
implements ClientIdentity {
    private final String certificate;
    private final String key;
    private final String clientId;

    public ClientCertificate(@Nullable String certificate, @Nullable String key, @Nullable String clientId) {
        this.certificate = certificate;
        this.key = key;
        this.clientId = clientId;
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public boolean isValid() {
        return ClientCertificate.hasValue(this.clientId) && ClientCertificate.hasValue(this.certificate) && ClientCertificate.hasValue(this.key);
    }

    @Override
    public boolean isCertificateBased() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientCertificate)) {
            return false;
        }
        ClientCertificate that = (ClientCertificate)o;
        return Objects.requireNonNull(this.certificate, "certificate must be provided").equals(that.certificate) && Objects.requireNonNull(this.key, "key must be provided").equals(that.key) && Objects.requireNonNull(this.clientId, "clientId must be provided").equals(that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.key, this.clientId);
    }

    private static boolean hasValue(String value) {
        return value != null && !value.isEmpty();
    }
}

