/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.ClientIdentity;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ClientCredentials
implements ClientIdentity,
Serializable {
    private static final long serialVersionUID = 2405162041950251807L;
    private final String clientSecret;
    private final String clientId;

    public ClientCredentials(@Nonnull String clientId, @Nonnull String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public String getSecret() {
        return this.clientSecret;
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public boolean isValid() {
        return ClientCredentials.hasValue(this.clientId) && ClientCredentials.hasValue(this.clientSecret);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCredentials that = (ClientCredentials)o;
        return Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.clientSecret, this.clientId);
    }

    public String toString() {
        return String.format("%s:%s", this.clientId, this.clientSecret);
    }

    private static boolean hasValue(String value) {
        return value != null && !value.isEmpty();
    }
}

