/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import org.slf4j.LoggerFactory;

public enum Service {
    XSUAA("xsuaa"),
    IAS(Service.getIasServiceName());

    private final String cloudFoundryName;

    private static String getIasServiceName() {
        String iasServiceName = System.getenv("IAS_SERVICE_NAME");
        LoggerFactory.getLogger(Service.class).error("IAS Service is not yet supported!!!");
        return iasServiceName;
    }

    private Service(String cloudFoundryName) {
        this.cloudFoundryName = cloudFoundryName;
    }

    public String getCFName() {
        if (this == IAS && this.cloudFoundryName == null) {
            LoggerFactory.getLogger(Service.class).error("IAS Service is not yet supported!!!");
        }
        return this.cloudFoundryName;
    }
}

