/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import javax.annotation.Nullable;

public enum GrantType {
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token"),
    PASSWORD("password"),
    JWT_BEARER("urn:ietf:params:oauth:grant-type:jwt-bearer"),
    SAML2_BEARER("urn:ietf:params:oauth:grant-type:saml2-bearer"),
    CLIENT_X509("client_x509"),
    AUTHORIZATION_CODE("authorization_code");

    private final String claimName;

    private GrantType(String claimName) {
        this.claimName = claimName;
    }

    public String toString() {
        return this.claimName;
    }

    @Nullable
    public static GrantType from(String claimName) {
        for (GrantType grantType : GrantType.values()) {
            if (!grantType.claimName.equals(claimName)) continue;
            return grantType;
        }
        return null;
    }
}

