/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import com.sap.cloud.security.config.ClientIdentity;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.annotation.Nullable;

public class ClientCertificate
implements ClientIdentity {
    private String certificate;
    private Certificate[] certificateChain;
    private PrivateKey privateKey;
    private String key;
    private final String clientId;

    public ClientCertificate(@Nullable String certificate, @Nullable String key, @Nullable String clientId) {
        this.certificate = certificate;
        this.key = key;
        this.clientId = clientId;
    }

    public ClientCertificate(@Nullable Certificate[] certificateChain, @Nullable PrivateKey privateKey, @Nullable String clientId) {
        this.certificateChain = certificateChain;
        this.privateKey = privateKey;
        this.clientId = clientId;
    }

    @Override
    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getId() {
        return this.clientId;
    }

    @Override
    public boolean isValid() {
        return ClientIdentity.hasValue(this.clientId) && this.isCertificateBased();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientCertificate)) {
            return false;
        }
        ClientCertificate that = (ClientCertificate)o;
        return Objects.requireNonNull(this.certificate, "certificate must be provided").equals(that.certificate) && Objects.requireNonNull(this.key, "key must be provided").equals(that.key) && Objects.requireNonNull(this.clientId, "clientId must be provided").equals(that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.key, this.clientId);
    }
}

