/*
 * Decompiled with CFR 0.152.
 */
package com.scapeak.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;

public class ReadNodeClient {
    private String deviceNopePrefix;
    public List<String> deviceNodeIds;

    public Map<String, Object> readValue(OpcUaClient client, CompletableFuture<OpcUaClient> future) throws Exception {
        if (this.deviceNopePrefix.isEmpty()) {
            throw new RuntimeException("\u8bbe\u5907\u8282\u70b9\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.deviceNopePrefix.endsWith(".")) {
            this.deviceNopePrefix = this.deviceNopePrefix + ".";
        }
        client.connect().get();
        HashMap<String, Object> readValueMap = new HashMap<String, Object>();
        if (!this.deviceNodeIds.isEmpty()) {
            for (String nodeName : this.deviceNodeIds) {
                NodeId node = new NodeId(1, this.deviceNopePrefix + nodeName);
                DataValue value2 = (DataValue)client.readValue(0.0, TimestampsToReturn.Both, node).get();
                readValueMap.put(node.getIdentifier().toString(), value2.getValue().getValue());
            }
        } else {
            List nodes = client.getAddressSpace().browseNodes(new NodeId(1, this.deviceNopePrefix));
            if (nodes.isEmpty()) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230:" + this.deviceNodeIds + "\u4e0b\u7684\u8282\u70b9");
            }
            for (UaNode uaNode : nodes) {
                NodeId node = uaNode.getNodeId();
                if (uaNode.getNodeClass() != NodeClass.Variable) continue;
                DataValue value2 = (DataValue)client.readValue(0.0, TimestampsToReturn.Both, node).get();
                readValueMap.put(node.getIdentifier().toString(), value2.getValue().getValue());
            }
        }
        return readValueMap;
    }
}

