/*
 * Decompiled with CFR 0.152.
 */
package com.scapeak.client;

import com.alibaba.fastjson2.JSONObject;
import com.scapeak.client.ClientRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class DataClient {
    public List<String> deviceNodeIds;
    private OpcUaClient client;
    private CompletableFuture<OpcUaClient> future;

    public DataClient(String opcuaUrl, String deviceNodePrefix, List<String> deviceNodeIds) throws Exception {
        if (deviceNodePrefix == null || deviceNodePrefix.isEmpty()) {
            throw new RuntimeException("\u8bbe\u5907\u524d\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!deviceNodePrefix.endsWith(".")) {
            deviceNodePrefix = deviceNodePrefix + ".";
        }
        if (deviceNodeIds.isEmpty()) {
            List nodes = this.client.getAddressSpace().browseNodes(new NodeId(1, deviceNodePrefix));
            if (nodes.isEmpty()) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230:" + deviceNodeIds + "\u4e0b\u7684\u8282\u70b9");
            }
            for (UaNode node : nodes) {
                deviceNodeIds.add(node.getNodeId().getIdentifier().toString());
            }
        } else {
            ListIterator<String> iterator = deviceNodeIds.listIterator();
            while (iterator.hasNext()) {
                String nodeId = iterator.next();
                nodeId = deviceNodePrefix + nodeId;
                iterator.set(nodeId);
            }
        }
        ClientRunner clientRunner = new ClientRunner(opcuaUrl);
        this.deviceNodeIds = deviceNodeIds;
        this.client = clientRunner.getClient();
        this.future = clientRunner.getFuture();
    }

    public Map<String, Object> readValue() throws Exception {
        this.client.connect().get();
        HashMap<String, Object> readValueMap = new HashMap<String, Object>();
        for (String node : this.deviceNodeIds) {
            NodeId nodeId = new NodeId(1, node);
            DataValue value = (DataValue)this.client.readValue(0.0, TimestampsToReturn.Both, nodeId).get();
            String itemName = node.substring(node.lastIndexOf(".") + 1);
            readValueMap.put(itemName, value.getValue().getValue());
        }
        this.future.complete(this.client);
        return readValueMap;
    }

    public void subscribeValue(RabbitTemplate rabbitTemplate, String exchangeName, String routeKey) throws ExecutionException, InterruptedException {
        this.client.connect().get();
        UaSubscription subscription = (UaSubscription)this.client.getSubscriptionManager().createSubscription(1000.0).get();
        ArrayList<MonitoredItemCreateRequest> requests = new ArrayList<MonitoredItemCreateRequest>();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (String node : this.deviceNodeIds) {
            MonitoringParameters parameters = new MonitoringParameters(Unsigned.uint((int)atomicInteger.getAndIncrement()), Double.valueOf(100.0), null, Unsigned.uint((int)10), Boolean.valueOf(true));
            ReadValueId readValueId = new ReadValueId(new NodeId(1, node), AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
            MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
            requests.add(request);
        }
        subscription.createMonitoredItems(TimestampsToReturn.Both, requests, (item, id) -> item.setValueConsumer((item1, value) -> {
            String itemName = item1.toString().substring(item1.toString().lastIndexOf(".") + 1);
            Object itemValue = value.getValue().getValue();
            rabbitTemplate.convertAndSend(exchangeName, routeKey, Objects.requireNonNull(new JSONObject().put((Object)itemName, itemValue)));
        })).get();
        Thread.sleep(Long.MAX_VALUE);
    }
}

