/*
 * Decompiled with CFR 0.152.
 */
package com.scapeak.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CompletableFuture<OpcUaClient> future = new CompletableFuture();
    private OpcUaClient client;

    public ClientRunner(String opcuaUrl) throws Exception {
        this.run(opcuaUrl);
    }

    Predicate<EndpointDescription> endpointFilter() {
        return e -> SecurityPolicy.None.getUri().equals(e.getSecurityPolicyUri());
    }

    public void createClient(String opcuaUrl) throws Exception {
        try {
            this.client = OpcUaClient.create((String)opcuaUrl, endpoints -> endpoints.stream().filter(this.endpointFilter()).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english((String)"eclipse milo opc-ua client")).setApplicationUri("urn:eclipse:milo:examples:client").setIdentityProvider((IdentityProvider)new AnonymousProvider()).setRequestTimeout(Unsigned.uint((int)5000)).build());
        }
        catch (UaException e) {
            this.logger.error("OPCUA\u8fde\u63a5\u5931\u8d25:{}", (Object)opcuaUrl);
            Thread.sleep(10000L);
            this.logger.info("OPCUA\u5c1d\u8bd5\u91cd\u8fde\u4e2d...{}", (Object)opcuaUrl);
            this.createClient(opcuaUrl);
        }
    }

    public ClientRunner run(String opcuaUrl) throws Exception {
        this.createClient(opcuaUrl);
        return this;
    }

    public CompletableFuture<OpcUaClient> getFuture() {
        return this.future;
    }

    public OpcUaClient getClient() {
        return this.client;
    }

    public void setClient(OpcUaClient client) {
        this.client = client;
    }
}

