/*
 * Decompiled with CFR 0.152.
 */
package com.scapeak.client;

import com.alibaba.fastjson2.JSONObject;
import com.scapeak.client.DataClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscriptionManager;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class SubscriptionListener
implements UaSubscriptionManager.SubscriptionListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DataClient dataClient;
    private final RabbitTemplate rabbitTemplate;
    private final String exchangeName;
    private final String routeKey;

    public SubscriptionListener(DataClient dataClient, RabbitTemplate rabbitTemplate, String exchangeName, String routeKey) {
        this.dataClient = dataClient;
        this.rabbitTemplate = rabbitTemplate;
        this.exchangeName = exchangeName;
        this.routeKey = routeKey;
    }

    public void onKeepAlive(UaSubscription subscription, DateTime publishTime) {
    }

    public void onStatusChanged(UaSubscription subscription, StatusCode status) {
        this.logger.info("onStatusChanged:{}", (Object)status);
    }

    public void onPublishFailure(UaException exception) {
        this.logger.error(exception.getMessage());
    }

    public void onNotificationDataLost(UaSubscription subscription) {
        this.logger.info("onNotificationDataLost");
    }

    public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
        this.logger.info("\u6062\u590d\u8fde\u63a5");
        try {
            subscription = (UaSubscription)this.dataClient.getClient().getSubscriptionManager().createSubscription(1000.0).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        NodeId nodeId1 = new NodeId(1, "Project.141A016M01.Data");
        ArrayList<MonitoredItemCreateRequest> requests = new ArrayList<MonitoredItemCreateRequest>();
        List nodes = null;
        try {
            nodes = this.dataClient.getClient().getAddressSpace().browseNodes(nodeId1);
        }
        catch (UaException e) {
            throw new RuntimeException(e);
        }
        AtomicInteger atomicInteger = new AtomicInteger(1);
        for (UaNode node : nodes) {
            MonitoringParameters parameters = new MonitoringParameters(Unsigned.uint((int)atomicInteger.getAndIncrement()), Double.valueOf(10.0), null, Unsigned.uint((int)10), Boolean.valueOf(true));
            if (node.getNodeId().getIdentifier().toString().equals("Project.141A016M01.Data.@ItemUpdatedTime")) continue;
            ReadValueId readValueId = new ReadValueId(new NodeId(1, node.getNodeId().getIdentifier().toString()), AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
            MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
            requests.add(request);
        }
        try {
            subscription.createMonitoredItems(TimestampsToReturn.Both, requests, (item, id) -> item.setValueConsumer((item1, value) -> {
                String itemValue = value.getValue().getValue().toString();
                String itemName = item1.getReadValueId().getNodeId().getIdentifier().toString();
                itemName = itemName.substring(itemName.lastIndexOf(".") + 1);
                if (itemValue.equals("true")) {
                    itemValue = "1";
                } else if (itemValue.equals("false")) {
                    itemValue = "0";
                }
                if (itemName.equals("@ItemUpdatedTime")) {
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)itemName, (Object)itemValue);
                jsonObject.put((Object)"deviceNodePrefix", (Object)this.dataClient.getDeviceNodePrefix());
                this.rabbitTemplate.convertAndSend(this.exchangeName, this.routeKey, (Object)jsonObject);
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

