package com.scapeak.client;

import com.alibaba.fastjson2.JSONObject;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscriptionManager;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

import static org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned.uint;

/**
 * @author sooyaaa
 * @createTime 2023/4/27
 */
public class SubscriptionListener implements UaSubscriptionManager.SubscriptionListener {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final DataClient dataClient;

    private final RabbitTemplate rabbitTemplate;

    private final String exchangeName;

    private final String routeKey;

    public SubscriptionListener(DataClient dataClient, RabbitTemplate rabbitTemplate, String exchangeName, String routeKey) {
        this.dataClient = dataClient;
        this.rabbitTemplate = rabbitTemplate;
        this.exchangeName = exchangeName;
        this.routeKey = routeKey;
    }

    @Override
    public void onKeepAlive(UaSubscription subscription, DateTime publishTime) {
   //     logger.info("onKeepAlive:{}", publishTime);
    }

    @Override
    public void onStatusChanged(UaSubscription subscription, StatusCode status) {
        logger.info("onStatusChanged:{}", status);
    }

    @Override
    public void onPublishFailure(UaException exception) {
        logger.error(exception.getMessage());
    }

    @Override
    public void onNotificationDataLost(UaSubscription subscription) {
        logger.info("onNotificationDataLost");
    }

    @Override
    public void onSubscriptionTransferFailed(UaSubscription subscription, StatusCode statusCode) {
        logger.info("恢复连接");
        try {
            subscription = dataClient.getClient().getSubscriptionManager().createSubscription(1000.0).get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        NodeId nodeId1 = new NodeId(1, dataClient.getDeviceNodePrefix());

        List<MonitoredItemCreateRequest> requests = new ArrayList<>();

        List<? extends UaNode> nodes = null;
        try {
            nodes =  dataClient.getClient().getAddressSpace().browseNodes(nodeId1);
        } catch (UaException e) {
            throw new RuntimeException(e);
        }
        AtomicInteger atomicInteger = new AtomicInteger(1);
        for (UaNode node : nodes) {
            MonitoringParameters parameters = new MonitoringParameters(
                    uint(atomicInteger.getAndIncrement()),
                    10.0,     // sampling interval
                    null,       // filter, null means use default
                    uint(10),   // queue size
                    true        // discard oldest
            );
            if (node.getNodeId().getIdentifier().toString().equals("Project.141A016M01.Data.@ItemUpdatedTime")) {
                continue;
            }
            ReadValueId readValueId = new ReadValueId(
                    new NodeId(1, node.getNodeId().getIdentifier().toString()),
                    AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE
            );
            MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
            requests.add(request);

        }
        // 创建监控项，并且作为变量值改变时候的回调函数。
        try {
            subscription.createMonitoredItems(
                    TimestampsToReturn.Both,
                    requests,
                    (item, id) -> {
                        item.setValueConsumer((item1, value) -> {
                            String itemValue = value.getValue().getValue().toString();
                            String itemName = item1.getReadValueId().getNodeId().getIdentifier().toString();
                            itemName = itemName.substring(itemName.lastIndexOf(".") + 1);
                            if (itemValue.equals("true")) {
                                itemValue = "1";
                            } else if (itemValue.equals("false")) {
                                itemValue = "0";
                            }
                            if (itemName.equals("@ItemUpdatedTime")) {
                                return;
                            }
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put(itemName, itemValue);
                            jsonObject.put("deviceNodePrefix", dataClient.getDeviceNodePrefix());
                          rabbitTemplate.convertAndSend(exchangeName, routeKey, jsonObject);
                         //   System.out.println("-----"+jsonObject.toJSONString());

                        });
                    }
            ).get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        // 一直订阅
        try {
            Thread.sleep(Long.MAX_VALUE);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

}
