/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.billing.requests.CountBillingProductsRequest;
import com.schematic.api.resources.billing.requests.CountCustomersRequest;
import com.schematic.api.resources.billing.requests.CreateBillingCustomerRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingPriceRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingProductRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingSubscriptionsRequestBody;
import com.schematic.api.resources.billing.requests.CreateCouponRequestBody;
import com.schematic.api.resources.billing.requests.CreateInvoiceRequestBody;
import com.schematic.api.resources.billing.requests.CreateMeterRequestBody;
import com.schematic.api.resources.billing.requests.CreatePaymentMethodRequestBody;
import com.schematic.api.resources.billing.requests.ListBillingProductsRequest;
import com.schematic.api.resources.billing.requests.ListCustomersRequest;
import com.schematic.api.resources.billing.requests.ListInvoicesRequest;
import com.schematic.api.resources.billing.requests.ListMetersRequest;
import com.schematic.api.resources.billing.requests.ListPaymentMethodsRequest;
import com.schematic.api.resources.billing.requests.ListProductPricesRequest;
import com.schematic.api.resources.billing.requests.SearchBillingPricesRequest;
import com.schematic.api.resources.billing.types.CountBillingProductsResponse;
import com.schematic.api.resources.billing.types.CountCustomersResponse;
import com.schematic.api.resources.billing.types.DeleteProductPriceResponse;
import com.schematic.api.resources.billing.types.ListBillingProductsResponse;
import com.schematic.api.resources.billing.types.ListCustomersResponse;
import com.schematic.api.resources.billing.types.ListInvoicesResponse;
import com.schematic.api.resources.billing.types.ListMetersResponse;
import com.schematic.api.resources.billing.types.ListPaymentMethodsResponse;
import com.schematic.api.resources.billing.types.ListProductPricesResponse;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCouponResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCustomerResponse;
import com.schematic.api.resources.billing.types.UpsertBillingMeterResponse;
import com.schematic.api.resources.billing.types.UpsertBillingPriceResponse;
import com.schematic.api.resources.billing.types.UpsertBillingProductResponse;
import com.schematic.api.resources.billing.types.UpsertBillingSubscriptionResponse;
import com.schematic.api.resources.billing.types.UpsertInvoiceResponse;
import com.schematic.api.resources.billing.types.UpsertPaymentMethodResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BillingClient {
    protected final ClientOptions clientOptions;

    public BillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public UpsertBillingCouponResponse upsertBillingCoupon(CreateCouponRequestBody request) {
        return this.upsertBillingCoupon(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingCouponResponse upsertBillingCoupon(CreateCouponRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/coupons").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingCouponResponse upsertBillingCouponResponse = (UpsertBillingCouponResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingCouponResponse.class);
                return upsertBillingCouponResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertBillingCustomerResponse upsertBillingCustomer(CreateBillingCustomerRequestBody request) {
        return this.upsertBillingCustomer(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingCustomerResponse upsertBillingCustomer(CreateBillingCustomerRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customer/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingCustomerResponse upsertBillingCustomerResponse = (UpsertBillingCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingCustomerResponse.class);
                return upsertBillingCustomerResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListCustomersResponse listCustomers() {
        return this.listCustomers(ListCustomersRequest.builder().build());
    }

    public ListCustomersResponse listCustomers(ListCustomersRequest request) {
        return this.listCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListCustomersResponse listCustomers(ListCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customers");
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        if (request.getFailedToImport().isPresent()) {
            httpUrl.addQueryParameter("failed_to_import", request.getFailedToImport().get().toString());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCustomersResponse listCustomersResponse = (ListCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCustomersResponse.class);
                return listCustomersResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CountCustomersResponse countCustomers() {
        return this.countCustomers(CountCustomersRequest.builder().build());
    }

    public CountCustomersResponse countCustomers(CountCustomersRequest request) {
        return this.countCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CountCustomersResponse countCustomers(CountCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customers/count");
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        if (request.getFailedToImport().isPresent()) {
            httpUrl.addQueryParameter("failed_to_import", request.getFailedToImport().get().toString());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CountCustomersResponse countCustomersResponse = (CountCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountCustomersResponse.class);
                return countCustomersResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListInvoicesResponse listInvoices(ListInvoicesRequest request) {
        return this.listInvoices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListInvoicesResponse listInvoices(ListInvoicesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/invoices");
        if (request.getCompanyId().isPresent()) {
            httpUrl.addQueryParameter("company_id", request.getCompanyId().get());
        }
        httpUrl.addQueryParameter("customer_external_id", request.getCustomerExternalId());
        if (request.getSubscriptionExternalId().isPresent()) {
            httpUrl.addQueryParameter("subscription_external_id", request.getSubscriptionExternalId().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListInvoicesResponse listInvoicesResponse = (ListInvoicesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListInvoicesResponse.class);
                return listInvoicesResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertInvoiceResponse upsertInvoice(CreateInvoiceRequestBody request) {
        return this.upsertInvoice(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertInvoiceResponse upsertInvoice(CreateInvoiceRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/invoices").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertInvoiceResponse upsertInvoiceResponse = (UpsertInvoiceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertInvoiceResponse.class);
                return upsertInvoiceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListMetersResponse listMeters() {
        return this.listMeters(ListMetersRequest.builder().build());
    }

    public ListMetersResponse listMeters(ListMetersRequest request) {
        return this.listMeters(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListMetersResponse listMeters(ListMetersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/meter");
        if (request.getDisplayName().isPresent()) {
            httpUrl.addQueryParameter("display_name", request.getDisplayName().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListMetersResponse listMetersResponse = (ListMetersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListMetersResponse.class);
                return listMetersResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertBillingMeterResponse upsertBillingMeter(CreateMeterRequestBody request) {
        return this.upsertBillingMeter(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingMeterResponse upsertBillingMeter(CreateMeterRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/meter/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingMeterResponse upsertBillingMeterResponse = (UpsertBillingMeterResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingMeterResponse.class);
                return upsertBillingMeterResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListPaymentMethodsResponse listPaymentMethods(ListPaymentMethodsRequest request) {
        return this.listPaymentMethods(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListPaymentMethodsResponse listPaymentMethods(ListPaymentMethodsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/payment-methods");
        if (request.getCompanyId().isPresent()) {
            httpUrl.addQueryParameter("company_id", request.getCompanyId().get());
        }
        httpUrl.addQueryParameter("customer_external_id", request.getCustomerExternalId());
        if (request.getSubscriptionExternalId().isPresent()) {
            httpUrl.addQueryParameter("subscription_external_id", request.getSubscriptionExternalId().get());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListPaymentMethodsResponse listPaymentMethodsResponse = (ListPaymentMethodsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPaymentMethodsResponse.class);
                return listPaymentMethodsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertPaymentMethodResponse upsertPaymentMethod(CreatePaymentMethodRequestBody request) {
        return this.upsertPaymentMethod(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertPaymentMethodResponse upsertPaymentMethod(CreatePaymentMethodRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/payment-methods").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertPaymentMethodResponse upsertPaymentMethodResponse = (UpsertPaymentMethodResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertPaymentMethodResponse.class);
                return upsertPaymentMethodResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public SearchBillingPricesResponse searchBillingPrices() {
        return this.searchBillingPrices(SearchBillingPricesRequest.builder().build());
    }

    public SearchBillingPricesResponse searchBillingPrices(SearchBillingPricesRequest request) {
        return this.searchBillingPrices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchBillingPricesResponse searchBillingPrices(SearchBillingPricesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/price");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getInterval().isPresent()) {
            httpUrl.addQueryParameter("interval", request.getInterval().get());
        }
        if (request.getUsageType().isPresent()) {
            httpUrl.addQueryParameter("usage_type", request.getUsageType().get());
        }
        if (request.getPrice().isPresent()) {
            httpUrl.addQueryParameter("price", request.getPrice().get().toString());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SearchBillingPricesResponse searchBillingPricesResponse = (SearchBillingPricesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchBillingPricesResponse.class);
                return searchBillingPricesResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertBillingPriceResponse upsertBillingPrice(CreateBillingPriceRequestBody request) {
        return this.upsertBillingPrice(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingPriceResponse upsertBillingPrice(CreateBillingPriceRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/price/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingPriceResponse upsertBillingPriceResponse = (UpsertBillingPriceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingPriceResponse.class);
                return upsertBillingPriceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListProductPricesResponse listProductPrices() {
        return this.listProductPrices(ListProductPricesRequest.builder().build());
    }

    public ListProductPricesResponse listProductPrices(ListProductPricesRequest request) {
        return this.listProductPrices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListProductPricesResponse listProductPrices(ListProductPricesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/prices");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getPriceUsageType().isPresent()) {
            httpUrl.addQueryParameter("price_usage_type", request.getPriceUsageType().get());
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            httpUrl.addQueryParameter("without_linked_to_plan", request.getWithoutLinkedToPlan().get().toString());
        }
        if (request.getWithZeroPrice().isPresent()) {
            httpUrl.addQueryParameter("with_zero_price", request.getWithZeroPrice().get().toString());
        }
        if (request.getWithPricesOnly().isPresent()) {
            httpUrl.addQueryParameter("with_prices_only", request.getWithPricesOnly().get().toString());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListProductPricesResponse listProductPricesResponse = (ListProductPricesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListProductPricesResponse.class);
                return listProductPricesResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public DeleteProductPriceResponse deleteProductPrice(String billingId) {
        return this.deleteProductPrice(billingId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteProductPriceResponse deleteProductPrice(String billingId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/prices").addPathSegment(billingId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                DeleteProductPriceResponse deleteProductPriceResponse = (DeleteProductPriceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteProductPriceResponse.class);
                return deleteProductPriceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertBillingProductResponse upsertBillingProduct(CreateBillingProductRequestBody request) {
        return this.upsertBillingProduct(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingProductResponse upsertBillingProduct(CreateBillingProductRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingProductResponse upsertBillingProductResponse = (UpsertBillingProductResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingProductResponse.class);
                return upsertBillingProductResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public ListBillingProductsResponse listBillingProducts() {
        return this.listBillingProducts(ListBillingProductsRequest.builder().build());
    }

    public ListBillingProductsResponse listBillingProducts(ListBillingProductsRequest request) {
        return this.listBillingProducts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListBillingProductsResponse listBillingProducts(ListBillingProductsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/products");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getPriceUsageType().isPresent()) {
            httpUrl.addQueryParameter("price_usage_type", request.getPriceUsageType().get());
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            httpUrl.addQueryParameter("without_linked_to_plan", request.getWithoutLinkedToPlan().get().toString());
        }
        if (request.getWithZeroPrice().isPresent()) {
            httpUrl.addQueryParameter("with_zero_price", request.getWithZeroPrice().get().toString());
        }
        if (request.getWithPricesOnly().isPresent()) {
            httpUrl.addQueryParameter("with_prices_only", request.getWithPricesOnly().get().toString());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListBillingProductsResponse listBillingProductsResponse = (ListBillingProductsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListBillingProductsResponse.class);
                return listBillingProductsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CountBillingProductsResponse countBillingProducts() {
        return this.countBillingProducts(CountBillingProductsRequest.builder().build());
    }

    public CountBillingProductsResponse countBillingProducts(CountBillingProductsRequest request) {
        return this.countBillingProducts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CountBillingProductsResponse countBillingProducts(CountBillingProductsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/products/count");
        if (request.getIds().isPresent()) {
            httpUrl.addQueryParameter("ids", request.getIds().get());
        }
        if (request.getName().isPresent()) {
            httpUrl.addQueryParameter("name", request.getName().get());
        }
        if (request.getQ().isPresent()) {
            httpUrl.addQueryParameter("q", request.getQ().get());
        }
        if (request.getPriceUsageType().isPresent()) {
            httpUrl.addQueryParameter("price_usage_type", request.getPriceUsageType().get());
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            httpUrl.addQueryParameter("without_linked_to_plan", request.getWithoutLinkedToPlan().get().toString());
        }
        if (request.getWithZeroPrice().isPresent()) {
            httpUrl.addQueryParameter("with_zero_price", request.getWithZeroPrice().get().toString());
        }
        if (request.getWithPricesOnly().isPresent()) {
            httpUrl.addQueryParameter("with_prices_only", request.getWithPricesOnly().get().toString());
        }
        if (request.getLimit().isPresent()) {
            httpUrl.addQueryParameter("limit", request.getLimit().get().toString());
        }
        if (request.getOffset().isPresent()) {
            httpUrl.addQueryParameter("offset", request.getOffset().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CountBillingProductsResponse countBillingProductsResponse = (CountBillingProductsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountBillingProductsResponse.class);
                return countBillingProductsResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpsertBillingSubscriptionResponse upsertBillingSubscription(CreateBillingSubscriptionsRequestBody request) {
        return this.upsertBillingSubscription(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpsertBillingSubscriptionResponse upsertBillingSubscription(CreateBillingSubscriptionsRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/subscription/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpsertBillingSubscriptionResponse upsertBillingSubscriptionResponse = (UpsertBillingSubscriptionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingSubscriptionResponse.class);
                return upsertBillingSubscriptionResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

