/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateMeterRequestBody {
    private final String displayName;
    private final String eventName;
    private final String eventPayloadKey;
    private final String externalId;
    private final Map<String, Object> additionalProperties;

    private CreateMeterRequestBody(String displayName, String eventName, String eventPayloadKey, String externalId, Map<String, Object> additionalProperties) {
        this.displayName = displayName;
        this.eventName = eventName;
        this.eventPayloadKey = eventPayloadKey;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="event_name")
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="event_payload_key")
    public String getEventPayloadKey() {
        return this.eventPayloadKey;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateMeterRequestBody && this.equalTo((CreateMeterRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateMeterRequestBody other) {
        return this.displayName.equals(other.displayName) && this.eventName.equals(other.eventName) && this.eventPayloadKey.equals(other.eventPayloadKey) && this.externalId.equals(other.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.eventName, this.eventPayloadKey, this.externalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisplayNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisplayNameStage,
    EventNameStage,
    EventPayloadKeyStage,
    ExternalIdStage,
    _FinalStage {
        private String displayName;
        private String eventName;
        private String eventPayloadKey;
        private String externalId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateMeterRequestBody other) {
            this.displayName(other.getDisplayName());
            this.eventName(other.getEventName());
            this.eventPayloadKey(other.getEventPayloadKey());
            this.externalId(other.getExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public EventNameStage displayName(@NotNull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_name")
        public EventPayloadKeyStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_payload_key")
        public ExternalIdStage eventPayloadKey(@NotNull String eventPayloadKey) {
            this.eventPayloadKey = Objects.requireNonNull(eventPayloadKey, "eventPayloadKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        public CreateMeterRequestBody build() {
            return new CreateMeterRequestBody(this.displayName, this.eventName, this.eventPayloadKey, this.externalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateMeterRequestBody build();
    }

    public static interface ExternalIdStage {
        public _FinalStage externalId(@NotNull String var1);
    }

    public static interface EventPayloadKeyStage {
        public ExternalIdStage eventPayloadKey(@NotNull String var1);
    }

    public static interface EventNameStage {
        public EventPayloadKeyStage eventName(@NotNull String var1);
    }

    public static interface DisplayNameStage {
        public EventNameStage displayName(@NotNull String var1);

        public Builder from(CreateMeterRequestBody var1);
    }
}

