/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCrmDealLineItemAssociationRequestBody {
    private final String dealExternalId;
    private final String lineItemExternalId;
    private final Map<String, Object> additionalProperties;

    private CreateCrmDealLineItemAssociationRequestBody(String dealExternalId, String lineItemExternalId, Map<String, Object> additionalProperties) {
        this.dealExternalId = dealExternalId;
        this.lineItemExternalId = lineItemExternalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="deal_external_id")
    public String getDealExternalId() {
        return this.dealExternalId;
    }

    @JsonProperty(value="line_item_external_id")
    public String getLineItemExternalId() {
        return this.lineItemExternalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCrmDealLineItemAssociationRequestBody && this.equalTo((CreateCrmDealLineItemAssociationRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmDealLineItemAssociationRequestBody other) {
        return this.dealExternalId.equals(other.dealExternalId) && this.lineItemExternalId.equals(other.lineItemExternalId);
    }

    public int hashCode() {
        return Objects.hash(this.dealExternalId, this.lineItemExternalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DealExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DealExternalIdStage,
    LineItemExternalIdStage,
    _FinalStage {
        private String dealExternalId;
        private String lineItemExternalId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCrmDealLineItemAssociationRequestBody other) {
            this.dealExternalId(other.getDealExternalId());
            this.lineItemExternalId(other.getLineItemExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="deal_external_id")
        public LineItemExternalIdStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="line_item_external_id")
        public _FinalStage lineItemExternalId(@NotNull String lineItemExternalId) {
            this.lineItemExternalId = Objects.requireNonNull(lineItemExternalId, "lineItemExternalId must not be null");
            return this;
        }

        @Override
        public CreateCrmDealLineItemAssociationRequestBody build() {
            return new CreateCrmDealLineItemAssociationRequestBody(this.dealExternalId, this.lineItemExternalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCrmDealLineItemAssociationRequestBody build();
    }

    public static interface LineItemExternalIdStage {
        public _FinalStage lineItemExternalId(@NotNull String var1);
    }

    public static interface DealExternalIdStage {
        public LineItemExternalIdStage dealExternalId(@NotNull String var1);

        public Builder from(CreateCrmDealLineItemAssociationRequestBody var1);
    }
}

