/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListFeatureUsersRequest {
    private final String featureId;
    private final Optional<String> q;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListFeatureUsersRequest(String featureId, Optional<String> q, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.featureId = featureId;
        this.q = q;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListFeatureUsersRequest && this.equalTo((ListFeatureUsersRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListFeatureUsersRequest other) {
        return this.featureId.equals(other.featureId) && this.q.equals(other.q) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.featureId, this.q, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FeatureIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FeatureIdStage,
    _FinalStage {
        private String featureId;
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> q = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListFeatureUsersRequest other) {
            this.featureId(other.getFeatureId());
            this.q(other.getQ());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public _FinalStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @Override
        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @Override
        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public _FinalStage q(Optional<String> q) {
            this.q = q;
            return this;
        }

        @Override
        public ListFeatureUsersRequest build() {
            return new ListFeatureUsersRequest(this.featureId, this.q, this.limit, this.offset, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListFeatureUsersRequest build();

        public _FinalStage q(Optional<String> var1);

        public _FinalStage q(String var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage offset(Optional<Integer> var1);

        public _FinalStage offset(Integer var1);
    }

    public static interface FeatureIdStage {
        public _FinalStage featureId(@NotNull String var1);

        public Builder from(ListFeatureUsersRequest var1);
    }
}

