/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.features.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.features.types.CreateFeatureRequestBodyFeatureType;
import com.schematic.api.types.CreateOrUpdateFlagRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateFeatureRequestBody {
    private final String description;
    private final Optional<String> eventSubtype;
    private final CreateFeatureRequestBodyFeatureType featureType;
    private final Optional<CreateOrUpdateFlagRequestBody> flag;
    private final Optional<String> icon;
    private final Optional<String> lifecyclePhase;
    private final Optional<String> maintainerId;
    private final String name;
    private final Optional<String> traitId;
    private final Map<String, Object> additionalProperties;

    private CreateFeatureRequestBody(String description, Optional<String> eventSubtype, CreateFeatureRequestBodyFeatureType featureType, Optional<CreateOrUpdateFlagRequestBody> flag, Optional<String> icon, Optional<String> lifecyclePhase, Optional<String> maintainerId, String name, Optional<String> traitId, Map<String, Object> additionalProperties) {
        this.description = description;
        this.eventSubtype = eventSubtype;
        this.featureType = featureType;
        this.flag = flag;
        this.icon = icon;
        this.lifecyclePhase = lifecyclePhase;
        this.maintainerId = maintainerId;
        this.name = name;
        this.traitId = traitId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="event_subtype")
    public Optional<String> getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="feature_type")
    public CreateFeatureRequestBodyFeatureType getFeatureType() {
        return this.featureType;
    }

    @JsonProperty(value="flag")
    public Optional<CreateOrUpdateFlagRequestBody> getFlag() {
        return this.flag;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="lifecycle_phase")
    public Optional<String> getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    @JsonProperty(value="maintainer_id")
    public Optional<String> getMaintainerId() {
        return this.maintainerId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="trait_id")
    public Optional<String> getTraitId() {
        return this.traitId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateFeatureRequestBody && this.equalTo((CreateFeatureRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateFeatureRequestBody other) {
        return this.description.equals(other.description) && this.eventSubtype.equals(other.eventSubtype) && this.featureType.equals((Object)other.featureType) && this.flag.equals(other.flag) && this.icon.equals(other.icon) && this.lifecyclePhase.equals(other.lifecyclePhase) && this.maintainerId.equals(other.maintainerId) && this.name.equals(other.name) && this.traitId.equals(other.traitId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.eventSubtype, this.featureType, this.flag, this.icon, this.lifecyclePhase, this.maintainerId, this.name, this.traitId});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DescriptionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DescriptionStage,
    FeatureTypeStage,
    NameStage,
    _FinalStage {
        private String description;
        private CreateFeatureRequestBodyFeatureType featureType;
        private String name;
        private Optional<String> traitId = Optional.empty();
        private Optional<String> maintainerId = Optional.empty();
        private Optional<String> lifecyclePhase = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<CreateOrUpdateFlagRequestBody> flag = Optional.empty();
        private Optional<String> eventSubtype = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateFeatureRequestBody other) {
            this.description(other.getDescription());
            this.eventSubtype(other.getEventSubtype());
            this.featureType(other.getFeatureType());
            this.flag(other.getFlag());
            this.icon(other.getIcon());
            this.lifecyclePhase(other.getLifecyclePhase());
            this.maintainerId(other.getMaintainerId());
            this.name(other.getName());
            this.traitId(other.getTraitId());
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public FeatureTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_type")
        public NameStage featureType(@NotNull CreateFeatureRequestBodyFeatureType featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage traitId(String traitId) {
            this.traitId = Optional.ofNullable(traitId);
            return this;
        }

        @Override
        @JsonSetter(value="trait_id", nulls=Nulls.SKIP)
        public _FinalStage traitId(Optional<String> traitId) {
            this.traitId = traitId;
            return this;
        }

        @Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @Override
        @JsonSetter(value="maintainer_id", nulls=Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @Override
        public _FinalStage lifecyclePhase(String lifecyclePhase) {
            this.lifecyclePhase = Optional.ofNullable(lifecyclePhase);
            return this;
        }

        @Override
        @JsonSetter(value="lifecycle_phase", nulls=Nulls.SKIP)
        public _FinalStage lifecyclePhase(Optional<String> lifecyclePhase) {
            this.lifecyclePhase = lifecyclePhase;
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage flag(CreateOrUpdateFlagRequestBody flag) {
            this.flag = Optional.ofNullable(flag);
            return this;
        }

        @Override
        @JsonSetter(value="flag", nulls=Nulls.SKIP)
        public _FinalStage flag(Optional<CreateOrUpdateFlagRequestBody> flag) {
            this.flag = flag;
            return this;
        }

        @Override
        public _FinalStage eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @Override
        @JsonSetter(value="event_subtype", nulls=Nulls.SKIP)
        public _FinalStage eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        @Override
        public CreateFeatureRequestBody build() {
            return new CreateFeatureRequestBody(this.description, this.eventSubtype, this.featureType, this.flag, this.icon, this.lifecyclePhase, this.maintainerId, this.name, this.traitId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateFeatureRequestBody build();

        public _FinalStage eventSubtype(Optional<String> var1);

        public _FinalStage eventSubtype(String var1);

        public _FinalStage flag(Optional<CreateOrUpdateFlagRequestBody> var1);

        public _FinalStage flag(CreateOrUpdateFlagRequestBody var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);

        public _FinalStage lifecyclePhase(Optional<String> var1);

        public _FinalStage lifecyclePhase(String var1);

        public _FinalStage maintainerId(Optional<String> var1);

        public _FinalStage maintainerId(String var1);

        public _FinalStage traitId(Optional<String> var1);

        public _FinalStage traitId(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface FeatureTypeStage {
        public NameStage featureType(@NotNull CreateFeatureRequestBodyFeatureType var1);
    }

    public static interface DescriptionStage {
        public FeatureTypeStage description(@NotNull String var1);

        public Builder from(CreateFeatureRequestBody var1);
    }
}

