/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plangroups;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.plangroups.requests.CreatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.requests.UpdatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.types.CreatePlanGroupResponse;
import com.schematic.api.resources.plangroups.types.GetPlanGroupResponse;
import com.schematic.api.resources.plangroups.types.UpdatePlanGroupResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class PlangroupsClient {
    protected final ClientOptions clientOptions;

    public PlangroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public GetPlanGroupResponse getPlanGroup() {
        return this.getPlanGroup(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetPlanGroupResponse getPlanGroup(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-groups").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                GetPlanGroupResponse getPlanGroupResponse = (GetPlanGroupResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPlanGroupResponse.class);
                return getPlanGroupResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public CreatePlanGroupResponse createPlanGroup(CreatePlanGroupRequestBody request) {
        return this.createPlanGroup(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreatePlanGroupResponse createPlanGroup(CreatePlanGroupRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-groups").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CreatePlanGroupResponse createPlanGroupResponse = (CreatePlanGroupResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreatePlanGroupResponse.class);
                return createPlanGroupResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public UpdatePlanGroupResponse updatePlanGroup(String planGroupId, UpdatePlanGroupRequestBody request) {
        return this.updatePlanGroup(planGroupId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpdatePlanGroupResponse updatePlanGroup(String planGroupId, UpdatePlanGroupRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-groups").addPathSegment(planGroupId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                UpdatePlanGroupResponse updatePlanGroupResponse = (UpdatePlanGroupResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdatePlanGroupResponse.class);
                return updatePlanGroupResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class));
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

