/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plangroups.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePlanGroupRequestBody {
    private final List<String> addOnIds;
    private final Optional<String> defaultPlanId;
    private final List<String> planIds;
    private final Optional<Integer> trialDays;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private UpdatePlanGroupRequestBody(List<String> addOnIds, Optional<String> defaultPlanId, List<String> planIds, Optional<Integer> trialDays, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.defaultPlanId = defaultPlanId;
        this.planIds = planIds;
        this.trialDays = trialDays;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_ids")
    public List<String> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="plan_ids")
    public List<String> getPlanIds() {
        return this.planIds;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePlanGroupRequestBody && this.equalTo((UpdatePlanGroupRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanGroupRequestBody other) {
        return this.addOnIds.equals(other.addOnIds) && this.defaultPlanId.equals(other.defaultPlanId) && this.planIds.equals(other.planIds) && this.trialDays.equals(other.trialDays) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOnIds, this.defaultPlanId, this.planIds, this.trialDays, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> addOnIds = new ArrayList<String>();
        private Optional<String> defaultPlanId = Optional.empty();
        private List<String> planIds = new ArrayList<String>();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdatePlanGroupRequestBody other) {
            this.addOnIds(other.getAddOnIds());
            this.defaultPlanId(other.getDefaultPlanId());
            this.planIds(other.getPlanIds());
            this.trialDays(other.getTrialDays());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public Builder addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        public Builder addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        public Builder addAllAddOnIds(List<String> addOnIds) {
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public Builder defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        public Builder defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public Builder planIds(List<String> planIds) {
            this.planIds.clear();
            this.planIds.addAll(planIds);
            return this;
        }

        public Builder addPlanIds(String planIds) {
            this.planIds.add(planIds);
            return this;
        }

        public Builder addAllPlanIds(List<String> planIds) {
            this.planIds.addAll(planIds);
            return this;
        }

        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public Builder trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        public Builder trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public Builder trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        public Builder trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        public UpdatePlanGroupRequestBody build() {
            return new UpdatePlanGroupRequestBody(this.addOnIds, this.defaultPlanId, this.planIds, this.trialDays, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }
}

