/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertBillingProductRequestBody {
    private final Optional<String> billingProductId;
    private final boolean isFreePlan;
    private final boolean isTrialable;
    private final Optional<String> monthlyPriceId;
    private final Optional<Integer> trialDays;
    private final Optional<String> yearlyPriceId;
    private final Map<String, Object> additionalProperties;

    private UpsertBillingProductRequestBody(Optional<String> billingProductId, boolean isFreePlan, boolean isTrialable, Optional<String> monthlyPriceId, Optional<Integer> trialDays, Optional<String> yearlyPriceId, Map<String, Object> additionalProperties) {
        this.billingProductId = billingProductId;
        this.isFreePlan = isFreePlan;
        this.isTrialable = isTrialable;
        this.monthlyPriceId = monthlyPriceId;
        this.trialDays = trialDays;
        this.yearlyPriceId = yearlyPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_product_id")
    public Optional<String> getBillingProductId() {
        return this.billingProductId;
    }

    @JsonProperty(value="is_free_plan")
    public boolean getIsFreePlan() {
        return this.isFreePlan;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price_id")
    public Optional<String> getMonthlyPriceId() {
        return this.monthlyPriceId;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="yearly_price_id")
    public Optional<String> getYearlyPriceId() {
        return this.yearlyPriceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertBillingProductRequestBody && this.equalTo((UpsertBillingProductRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertBillingProductRequestBody other) {
        return this.billingProductId.equals(other.billingProductId) && this.isFreePlan == other.isFreePlan && this.isTrialable == other.isTrialable && this.monthlyPriceId.equals(other.monthlyPriceId) && this.trialDays.equals(other.trialDays) && this.yearlyPriceId.equals(other.yearlyPriceId);
    }

    public int hashCode() {
        return Objects.hash(this.billingProductId, this.isFreePlan, this.isTrialable, this.monthlyPriceId, this.trialDays, this.yearlyPriceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IsFreePlanStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IsFreePlanStage,
    IsTrialableStage,
    _FinalStage {
        private boolean isFreePlan;
        private boolean isTrialable;
        private Optional<String> yearlyPriceId = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<String> monthlyPriceId = Optional.empty();
        private Optional<String> billingProductId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertBillingProductRequestBody other) {
            this.billingProductId(other.getBillingProductId());
            this.isFreePlan(other.getIsFreePlan());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPriceId(other.getMonthlyPriceId());
            this.trialDays(other.getTrialDays());
            this.yearlyPriceId(other.getYearlyPriceId());
            return this;
        }

        @Override
        @JsonSetter(value="is_free_plan")
        public IsTrialableStage isFreePlan(boolean isFreePlan) {
            this.isFreePlan = isFreePlan;
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public _FinalStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        public _FinalStage yearlyPriceId(String yearlyPriceId) {
            this.yearlyPriceId = Optional.ofNullable(yearlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price_id", nulls=Nulls.SKIP)
        public _FinalStage yearlyPriceId(Optional<String> yearlyPriceId) {
            this.yearlyPriceId = yearlyPriceId;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage monthlyPriceId(String monthlyPriceId) {
            this.monthlyPriceId = Optional.ofNullable(monthlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price_id", nulls=Nulls.SKIP)
        public _FinalStage monthlyPriceId(Optional<String> monthlyPriceId) {
            this.monthlyPriceId = monthlyPriceId;
            return this;
        }

        @Override
        public _FinalStage billingProductId(String billingProductId) {
            this.billingProductId = Optional.ofNullable(billingProductId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product_id", nulls=Nulls.SKIP)
        public _FinalStage billingProductId(Optional<String> billingProductId) {
            this.billingProductId = billingProductId;
            return this;
        }

        @Override
        public UpsertBillingProductRequestBody build() {
            return new UpsertBillingProductRequestBody(this.billingProductId, this.isFreePlan, this.isTrialable, this.monthlyPriceId, this.trialDays, this.yearlyPriceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertBillingProductRequestBody build();

        public _FinalStage billingProductId(Optional<String> var1);

        public _FinalStage billingProductId(String var1);

        public _FinalStage monthlyPriceId(Optional<String> var1);

        public _FinalStage monthlyPriceId(String var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage yearlyPriceId(Optional<String> var1);

        public _FinalStage yearlyPriceId(String var1);
    }

    public static interface IsTrialableStage {
        public _FinalStage isTrialable(boolean var1);
    }

    public static interface IsFreePlanStage {
        public IsTrialableStage isFreePlan(boolean var1);

        public Builder from(UpsertBillingProductRequestBody var1);
    }
}

