/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.webhooks.types.CreateWebhookRequestBodyRequestTypesItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateWebhookRequestBody {
    private final String name;
    private final List<CreateWebhookRequestBodyRequestTypesItem> requestTypes;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private CreateWebhookRequestBody(String name, List<CreateWebhookRequestBodyRequestTypesItem> requestTypes, String url, Map<String, Object> additionalProperties) {
        this.name = name;
        this.requestTypes = requestTypes;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request_types")
    public List<CreateWebhookRequestBodyRequestTypesItem> getRequestTypes() {
        return this.requestTypes;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateWebhookRequestBody && this.equalTo((CreateWebhookRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateWebhookRequestBody other) {
        return this.name.equals(other.name) && this.requestTypes.equals(other.requestTypes) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.requestTypes, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    UrlStage,
    _FinalStage {
        private String name;
        private String url;
        private List<CreateWebhookRequestBodyRequestTypesItem> requestTypes = new ArrayList<CreateWebhookRequestBodyRequestTypesItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateWebhookRequestBody other) {
            this.name(other.getName());
            this.requestTypes(other.getRequestTypes());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            this.requestTypes.addAll(requestTypes);
            return this;
        }

        @Override
        public _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem requestTypes) {
            this.requestTypes.add(requestTypes);
            return this;
        }

        @Override
        @JsonSetter(value="request_types", nulls=Nulls.SKIP)
        public _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            this.requestTypes.clear();
            this.requestTypes.addAll(requestTypes);
            return this;
        }

        @Override
        public CreateWebhookRequestBody build() {
            return new CreateWebhookRequestBody(this.name, this.requestTypes, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateWebhookRequestBody build();

        public _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> var1);

        public _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem var1);

        public _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface NameStage {
        public UrlStage name(@NotNull String var1);

        public Builder from(CreateWebhookRequestBody var1);
    }
}

