/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingProductForSubscriptionResponseData {
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String environmentId;
    private final String externalId;
    private final String id;
    private final String interval;
    private final Optional<String> meterId;
    private final String name;
    private final int price;
    private final String priceExternalId;
    private final String priceId;
    private final double quantity;
    private final String subscriptionId;
    private final OffsetDateTime updatedAt;
    private final String usageType;
    private final Map<String, Object> additionalProperties;

    private BillingProductForSubscriptionResponseData(OffsetDateTime createdAt, String currency, String environmentId, String externalId, String id, String interval, Optional<String> meterId, String name, int price, String priceExternalId, String priceId, double quantity, String subscriptionId, OffsetDateTime updatedAt, String usageType, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.currency = currency;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.id = id;
        this.interval = interval;
        this.meterId = meterId;
        this.name = name;
        this.price = price;
        this.priceExternalId = priceExternalId;
        this.priceId = priceId;
        this.quantity = quantity;
        this.subscriptionId = subscriptionId;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="price_id")
    public String getPriceId() {
        return this.priceId;
    }

    @JsonProperty(value="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="subscription_id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="usage_type")
    public String getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingProductForSubscriptionResponseData && this.equalTo((BillingProductForSubscriptionResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductForSubscriptionResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.environmentId.equals(other.environmentId) && this.externalId.equals(other.externalId) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.meterId.equals(other.meterId) && this.name.equals(other.name) && this.price == other.price && this.priceExternalId.equals(other.priceExternalId) && this.priceId.equals(other.priceId) && this.quantity == other.quantity && this.subscriptionId.equals(other.subscriptionId) && this.updatedAt.equals(other.updatedAt) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.currency, this.environmentId, this.externalId, this.id, this.interval, this.meterId, this.name, this.price, this.priceExternalId, this.priceId, this.quantity, this.subscriptionId, this.updatedAt, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    CurrencyStage,
    EnvironmentIdStage,
    ExternalIdStage,
    IdStage,
    IntervalStage,
    NameStage,
    PriceStage,
    PriceExternalIdStage,
    PriceIdStage,
    QuantityStage,
    SubscriptionIdStage,
    UpdatedAtStage,
    UsageTypeStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String currency;
        private String environmentId;
        private String externalId;
        private String id;
        private String interval;
        private String name;
        private int price;
        private String priceExternalId;
        private String priceId;
        private double quantity;
        private String subscriptionId;
        private OffsetDateTime updatedAt;
        private String usageType;
        private Optional<String> meterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingProductForSubscriptionResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.environmentId(other.getEnvironmentId());
            this.externalId(other.getExternalId());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.meterId(other.getMeterId());
            this.name(other.getName());
            this.price(other.getPrice());
            this.priceExternalId(other.getPriceExternalId());
            this.priceId(other.getPriceId());
            this.quantity(other.getQuantity());
            this.subscriptionId(other.getSubscriptionId());
            this.updatedAt(other.getUpdatedAt());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public EnvironmentIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public IdStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public NameStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public PriceIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_id")
        public QuantityStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public SubscriptionIdStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="subscription_id")
        public UpdatedAtStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public BillingProductForSubscriptionResponseData build() {
            return new BillingProductForSubscriptionResponseData(this.createdAt, this.currency, this.environmentId, this.externalId, this.id, this.interval, this.meterId, this.name, this.price, this.priceExternalId, this.priceId, this.quantity, this.subscriptionId, this.updatedAt, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingProductForSubscriptionResponseData build();

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface SubscriptionIdStage {
        public UpdatedAtStage subscriptionId(@NotNull String var1);
    }

    public static interface QuantityStage {
        public SubscriptionIdStage quantity(double var1);
    }

    public static interface PriceIdStage {
        public QuantityStage priceId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public PriceIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface IntervalStage {
        public NameStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface ExternalIdStage {
        public IdStage externalId(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public ExternalIdStage environmentId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public EnvironmentIdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(BillingProductForSubscriptionResponseData var1);
    }
}

