/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingProductPriceResponseData {
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String id;
    private final String interval;
    private final boolean isActive;
    private final Optional<String> meterId;
    private final int price;
    private final String priceExternalId;
    private final String productExternalId;
    private final OffsetDateTime updatedAt;
    private final String usageType;
    private final Map<String, Object> additionalProperties;

    private BillingProductPriceResponseData(OffsetDateTime createdAt, String currency, String id, String interval, boolean isActive, Optional<String> meterId, int price, String priceExternalId, String productExternalId, OffsetDateTime updatedAt, String usageType, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.currency = currency;
        this.id = id;
        this.interval = interval;
        this.isActive = isActive;
        this.meterId = meterId;
        this.price = price;
        this.priceExternalId = priceExternalId;
        this.productExternalId = productExternalId;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="usage_type")
    public String getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingProductPriceResponseData && this.equalTo((BillingProductPriceResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPriceResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.isActive == other.isActive && this.meterId.equals(other.meterId) && this.price == other.price && this.priceExternalId.equals(other.priceExternalId) && this.productExternalId.equals(other.productExternalId) && this.updatedAt.equals(other.updatedAt) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.currency, this.id, this.interval, this.isActive, this.meterId, this.price, this.priceExternalId, this.productExternalId, this.updatedAt, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    CurrencyStage,
    IdStage,
    IntervalStage,
    IsActiveStage,
    PriceStage,
    PriceExternalIdStage,
    ProductExternalIdStage,
    UpdatedAtStage,
    UsageTypeStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String currency;
        private String id;
        private String interval;
        private boolean isActive;
        private int price;
        private String priceExternalId;
        private String productExternalId;
        private OffsetDateTime updatedAt;
        private String usageType;
        private Optional<String> meterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingProductPriceResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.isActive(other.getIsActive());
            this.meterId(other.getMeterId());
            this.price(other.getPrice());
            this.priceExternalId(other.getPriceExternalId());
            this.productExternalId(other.getProductExternalId());
            this.updatedAt(other.getUpdatedAt());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public IdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public PriceStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public UpdatedAtStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public BillingProductPriceResponseData build() {
            return new BillingProductPriceResponseData(this.createdAt, this.currency, this.id, this.interval, this.isActive, this.meterId, this.price, this.priceExternalId, this.productExternalId, this.updatedAt, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingProductPriceResponseData build();

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ProductExternalIdStage {
        public UpdatedAtStage productExternalId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public ProductExternalIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface IsActiveStage {
        public PriceStage isActive(boolean var1);
    }

    public static interface IntervalStage {
        public IsActiveStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public IdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(BillingProductPriceResponseData var1);
    }
}

