/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreateOrUpdateConditionGroupRequestBody;
import com.schematic.api.types.CreateOrUpdateConditionRequestBody;
import com.schematic.api.types.CreateOrUpdateRuleRequestBodyRuleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrUpdateRuleRequestBody {
    private final List<CreateOrUpdateConditionGroupRequestBody> conditionGroups;
    private final List<CreateOrUpdateConditionRequestBody> conditions;
    private final Optional<String> id;
    private final String name;
    private final int priority;
    private final Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType;
    private final boolean value;
    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateRuleRequestBody(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups, List<CreateOrUpdateConditionRequestBody> conditions, Optional<String> id, String name, int priority, Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType, boolean value, Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.id = id;
        this.name = name;
        this.priority = priority;
        this.ruleType = ruleType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="condition_groups")
    public List<CreateOrUpdateConditionGroupRequestBody> getConditionGroups() {
        return this.conditionGroups;
    }

    @JsonProperty(value="conditions")
    public List<CreateOrUpdateConditionRequestBody> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty(value="rule_type")
    public Optional<CreateOrUpdateRuleRequestBodyRuleType> getRuleType() {
        return this.ruleType;
    }

    @JsonProperty(value="value")
    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrUpdateRuleRequestBody && this.equalTo((CreateOrUpdateRuleRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateRuleRequestBody other) {
        return this.conditionGroups.equals(other.conditionGroups) && this.conditions.equals(other.conditions) && this.id.equals(other.id) && this.name.equals(other.name) && this.priority == other.priority && this.ruleType.equals(other.ruleType) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.conditionGroups, this.conditions, this.id, this.name, this.priority, this.ruleType, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    PriorityStage,
    ValueStage,
    _FinalStage {
        private String name;
        private int priority;
        private boolean value;
        private Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType = Optional.empty();
        private Optional<String> id = Optional.empty();
        private List<CreateOrUpdateConditionRequestBody> conditions = new ArrayList<CreateOrUpdateConditionRequestBody>();
        private List<CreateOrUpdateConditionGroupRequestBody> conditionGroups = new ArrayList<CreateOrUpdateConditionGroupRequestBody>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateOrUpdateRuleRequestBody other) {
            this.conditionGroups(other.getConditionGroups());
            this.conditions(other.getConditions());
            this.id(other.getId());
            this.name(other.getName());
            this.priority(other.getPriority());
            this.ruleType(other.getRuleType());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="priority")
        public ValueStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage ruleType(CreateOrUpdateRuleRequestBodyRuleType ruleType) {
            this.ruleType = Optional.ofNullable(ruleType);
            return this;
        }

        @Override
        @JsonSetter(value="rule_type", nulls=Nulls.SKIP)
        public _FinalStage ruleType(Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @Override
        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @Override
        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        @Override
        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @Override
        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @Override
        @JsonSetter(value="condition_groups", nulls=Nulls.SKIP)
        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.clear();
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @Override
        public CreateOrUpdateRuleRequestBody build() {
            return new CreateOrUpdateRuleRequestBody(this.conditionGroups, this.conditions, this.id, this.name, this.priority, this.ruleType, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateOrUpdateRuleRequestBody build();

        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> var1);

        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody var1);

        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> var1);

        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> var1);

        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody var1);

        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> var1);

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage ruleType(Optional<CreateOrUpdateRuleRequestBodyRuleType> var1);

        public _FinalStage ruleType(CreateOrUpdateRuleRequestBodyRuleType var1);
    }

    public static interface ValueStage {
        public _FinalStage value(boolean var1);
    }

    public static interface PriorityStage {
        public ValueStage priority(int var1);
    }

    public static interface NameStage {
        public PriorityStage name(@NotNull String var1);

        public Builder from(CreateOrUpdateRuleRequestBody var1);
    }
}

