/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.EventBodyFlagCheck;
import com.schematic.api.types.EventBodyIdentify;
import com.schematic.api.types.EventBodyTrack;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class EventBody {
    private final Object value;
    private final int type;

    private EventBody(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((EventBodyTrack)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((EventBodyFlagCheck)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((EventBodyIdentify)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventBody && this.equalTo((EventBody)other);
    }

    private boolean equalTo(EventBody other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static EventBody of(EventBodyTrack value) {
        return new EventBody(value, 0);
    }

    public static EventBody of(EventBodyFlagCheck value) {
        return new EventBody(value, 1);
    }

    public static EventBody of(EventBodyIdentify value) {
        return new EventBody(value, 2);
    }

    static final class Deserializer
    extends StdDeserializer<EventBody> {
        Deserializer() {
            super(EventBody.class);
        }

        public EventBody deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return EventBody.of((EventBodyTrack)ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyTrack.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return EventBody.of((EventBodyFlagCheck)ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyFlagCheck.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return EventBody.of((EventBodyIdentify)ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyIdentify.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(EventBodyTrack var1);

        public T visit(EventBodyFlagCheck var1);

        public T visit(EventBodyIdentify var1);
    }
}

