/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceView;
import com.schematic.api.types.EntityTraitDefinitionResponseData;
import com.schematic.api.types.FeatureResponseData;
import com.schematic.api.types.PlanResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanEntitlementResponseData {
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final Optional<FeatureResponseData> feature;
    private final String featureId;
    private final String id;
    private final Optional<BillingPriceView> meteredMonthlyPrice;
    private final Optional<BillingPriceView> meteredYearlyPrice;
    private final Optional<String> metricPeriod;
    private final Optional<String> metricPeriodMonthReset;
    private final Optional<PlanResponseData> plan;
    private final String planId;
    private final Optional<String> priceBehavior;
    private final String ruleId;
    private final Optional<String> ruleIdUsageExceeded;
    private final OffsetDateTime updatedAt;
    private final Optional<Boolean> valueBool;
    private final Optional<Integer> valueNumeric;
    private final Optional<EntityTraitDefinitionResponseData> valueTrait;
    private final Optional<String> valueTraitId;
    private final String valueType;
    private final Map<String, Object> additionalProperties;

    private PlanEntitlementResponseData(OffsetDateTime createdAt, String environmentId, Optional<FeatureResponseData> feature, String featureId, String id, Optional<BillingPriceView> meteredMonthlyPrice, Optional<BillingPriceView> meteredYearlyPrice, Optional<String> metricPeriod, Optional<String> metricPeriodMonthReset, Optional<PlanResponseData> plan, String planId, Optional<String> priceBehavior, String ruleId, Optional<String> ruleIdUsageExceeded, OffsetDateTime updatedAt, Optional<Boolean> valueBool, Optional<Integer> valueNumeric, Optional<EntityTraitDefinitionResponseData> valueTrait, Optional<String> valueTraitId, String valueType, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.feature = feature;
        this.featureId = featureId;
        this.id = id;
        this.meteredMonthlyPrice = meteredMonthlyPrice;
        this.meteredYearlyPrice = meteredYearlyPrice;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.plan = plan;
        this.planId = planId;
        this.priceBehavior = priceBehavior;
        this.ruleId = ruleId;
        this.ruleIdUsageExceeded = ruleIdUsageExceeded;
        this.updatedAt = updatedAt;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueTrait = valueTrait;
        this.valueTraitId = valueTraitId;
        this.valueType = valueType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="metered_monthly_price")
    public Optional<BillingPriceView> getMeteredMonthlyPrice() {
        return this.meteredMonthlyPrice;
    }

    @JsonProperty(value="metered_yearly_price")
    public Optional<BillingPriceView> getMeteredYearlyPrice() {
        return this.meteredYearlyPrice;
    }

    @JsonProperty(value="metric_period")
    public Optional<String> getMetricPeriod() {
        return this.metricPeriod;
    }

    @JsonProperty(value="metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return this.metricPeriodMonthReset;
    }

    @JsonProperty(value="plan")
    public Optional<PlanResponseData> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="price_behavior")
    public Optional<String> getPriceBehavior() {
        return this.priceBehavior;
    }

    @JsonProperty(value="rule_id")
    public String getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="rule_id_usage_exceeded")
    public Optional<String> getRuleIdUsageExceeded() {
        return this.ruleIdUsageExceeded;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="value_bool")
    public Optional<Boolean> getValueBool() {
        return this.valueBool;
    }

    @JsonProperty(value="value_numeric")
    public Optional<Integer> getValueNumeric() {
        return this.valueNumeric;
    }

    @JsonProperty(value="value_trait")
    public Optional<EntityTraitDefinitionResponseData> getValueTrait() {
        return this.valueTrait;
    }

    @JsonProperty(value="value_trait_id")
    public Optional<String> getValueTraitId() {
        return this.valueTraitId;
    }

    @JsonProperty(value="value_type")
    public String getValueType() {
        return this.valueType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanEntitlementResponseData && this.equalTo((PlanEntitlementResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanEntitlementResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.feature.equals(other.feature) && this.featureId.equals(other.featureId) && this.id.equals(other.id) && this.meteredMonthlyPrice.equals(other.meteredMonthlyPrice) && this.meteredYearlyPrice.equals(other.meteredYearlyPrice) && this.metricPeriod.equals(other.metricPeriod) && this.metricPeriodMonthReset.equals(other.metricPeriodMonthReset) && this.plan.equals(other.plan) && this.planId.equals(other.planId) && this.priceBehavior.equals(other.priceBehavior) && this.ruleId.equals(other.ruleId) && this.ruleIdUsageExceeded.equals(other.ruleIdUsageExceeded) && this.updatedAt.equals(other.updatedAt) && this.valueBool.equals(other.valueBool) && this.valueNumeric.equals(other.valueNumeric) && this.valueTrait.equals(other.valueTrait) && this.valueTraitId.equals(other.valueTraitId) && this.valueType.equals(other.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.environmentId, this.feature, this.featureId, this.id, this.meteredMonthlyPrice, this.meteredYearlyPrice, this.metricPeriod, this.metricPeriodMonthReset, this.plan, this.planId, this.priceBehavior, this.ruleId, this.ruleIdUsageExceeded, this.updatedAt, this.valueBool, this.valueNumeric, this.valueTrait, this.valueTraitId, this.valueType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentIdStage,
    FeatureIdStage,
    IdStage,
    PlanIdStage,
    RuleIdStage,
    UpdatedAtStage,
    ValueTypeStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentId;
        private String featureId;
        private String id;
        private String planId;
        private String ruleId;
        private OffsetDateTime updatedAt;
        private String valueType;
        private Optional<String> valueTraitId = Optional.empty();
        private Optional<EntityTraitDefinitionResponseData> valueTrait = Optional.empty();
        private Optional<Integer> valueNumeric = Optional.empty();
        private Optional<Boolean> valueBool = Optional.empty();
        private Optional<String> ruleIdUsageExceeded = Optional.empty();
        private Optional<String> priceBehavior = Optional.empty();
        private Optional<PlanResponseData> plan = Optional.empty();
        private Optional<String> metricPeriodMonthReset = Optional.empty();
        private Optional<String> metricPeriod = Optional.empty();
        private Optional<BillingPriceView> meteredYearlyPrice = Optional.empty();
        private Optional<BillingPriceView> meteredMonthlyPrice = Optional.empty();
        private Optional<FeatureResponseData> feature = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanEntitlementResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.feature(other.getFeature());
            this.featureId(other.getFeatureId());
            this.id(other.getId());
            this.meteredMonthlyPrice(other.getMeteredMonthlyPrice());
            this.meteredYearlyPrice(other.getMeteredYearlyPrice());
            this.metricPeriod(other.getMetricPeriod());
            this.metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            this.plan(other.getPlan());
            this.planId(other.getPlanId());
            this.priceBehavior(other.getPriceBehavior());
            this.ruleId(other.getRuleId());
            this.ruleIdUsageExceeded(other.getRuleIdUsageExceeded());
            this.updatedAt(other.getUpdatedAt());
            this.valueBool(other.getValueBool());
            this.valueNumeric(other.getValueNumeric());
            this.valueTrait(other.getValueTrait());
            this.valueTraitId(other.getValueTraitId());
            this.valueType(other.getValueType());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public FeatureIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public IdStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public RuleIdStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="rule_id")
        public UpdatedAtStage ruleId(@NotNull String ruleId) {
            this.ruleId = Objects.requireNonNull(ruleId, "ruleId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValueTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value_type")
        public _FinalStage valueType(@NotNull String valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @Override
        public _FinalStage valueTraitId(String valueTraitId) {
            this.valueTraitId = Optional.ofNullable(valueTraitId);
            return this;
        }

        @Override
        @JsonSetter(value="value_trait_id", nulls=Nulls.SKIP)
        public _FinalStage valueTraitId(Optional<String> valueTraitId) {
            this.valueTraitId = valueTraitId;
            return this;
        }

        @Override
        public _FinalStage valueTrait(EntityTraitDefinitionResponseData valueTrait) {
            this.valueTrait = Optional.ofNullable(valueTrait);
            return this;
        }

        @Override
        @JsonSetter(value="value_trait", nulls=Nulls.SKIP)
        public _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> valueTrait) {
            this.valueTrait = valueTrait;
            return this;
        }

        @Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @Override
        @JsonSetter(value="value_numeric", nulls=Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @Override
        @JsonSetter(value="value_bool", nulls=Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @Override
        public _FinalStage ruleIdUsageExceeded(String ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = Optional.ofNullable(ruleIdUsageExceeded);
            return this;
        }

        @Override
        @JsonSetter(value="rule_id_usage_exceeded", nulls=Nulls.SKIP)
        public _FinalStage ruleIdUsageExceeded(Optional<String> ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = ruleIdUsageExceeded;
            return this;
        }

        @Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @Override
        @JsonSetter(value="price_behavior", nulls=Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @Override
        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period_month_reset", nulls=Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period", nulls=Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @Override
        public _FinalStage meteredYearlyPrice(BillingPriceView meteredYearlyPrice) {
            this.meteredYearlyPrice = Optional.ofNullable(meteredYearlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="metered_yearly_price", nulls=Nulls.SKIP)
        public _FinalStage meteredYearlyPrice(Optional<BillingPriceView> meteredYearlyPrice) {
            this.meteredYearlyPrice = meteredYearlyPrice;
            return this;
        }

        @Override
        public _FinalStage meteredMonthlyPrice(BillingPriceView meteredMonthlyPrice) {
            this.meteredMonthlyPrice = Optional.ofNullable(meteredMonthlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="metered_monthly_price", nulls=Nulls.SKIP)
        public _FinalStage meteredMonthlyPrice(Optional<BillingPriceView> meteredMonthlyPrice) {
            this.meteredMonthlyPrice = meteredMonthlyPrice;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public PlanEntitlementResponseData build() {
            return new PlanEntitlementResponseData(this.createdAt, this.environmentId, this.feature, this.featureId, this.id, this.meteredMonthlyPrice, this.meteredYearlyPrice, this.metricPeriod, this.metricPeriodMonthReset, this.plan, this.planId, this.priceBehavior, this.ruleId, this.ruleIdUsageExceeded, this.updatedAt, this.valueBool, this.valueNumeric, this.valueTrait, this.valueTraitId, this.valueType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanEntitlementResponseData build();

        public _FinalStage feature(Optional<FeatureResponseData> var1);

        public _FinalStage feature(FeatureResponseData var1);

        public _FinalStage meteredMonthlyPrice(Optional<BillingPriceView> var1);

        public _FinalStage meteredMonthlyPrice(BillingPriceView var1);

        public _FinalStage meteredYearlyPrice(Optional<BillingPriceView> var1);

        public _FinalStage meteredYearlyPrice(BillingPriceView var1);

        public _FinalStage metricPeriod(Optional<String> var1);

        public _FinalStage metricPeriod(String var1);

        public _FinalStage metricPeriodMonthReset(Optional<String> var1);

        public _FinalStage metricPeriodMonthReset(String var1);

        public _FinalStage plan(Optional<PlanResponseData> var1);

        public _FinalStage plan(PlanResponseData var1);

        public _FinalStage priceBehavior(Optional<String> var1);

        public _FinalStage priceBehavior(String var1);

        public _FinalStage ruleIdUsageExceeded(Optional<String> var1);

        public _FinalStage ruleIdUsageExceeded(String var1);

        public _FinalStage valueBool(Optional<Boolean> var1);

        public _FinalStage valueBool(Boolean var1);

        public _FinalStage valueNumeric(Optional<Integer> var1);

        public _FinalStage valueNumeric(Integer var1);

        public _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> var1);

        public _FinalStage valueTrait(EntityTraitDefinitionResponseData var1);

        public _FinalStage valueTraitId(Optional<String> var1);

        public _FinalStage valueTraitId(String var1);
    }

    public static interface ValueTypeStage {
        public _FinalStage valueType(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public ValueTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface RuleIdStage {
        public UpdatedAtStage ruleId(@NotNull String var1);
    }

    public static interface PlanIdStage {
        public RuleIdStage planId(@NotNull String var1);
    }

    public static interface IdStage {
        public PlanIdStage id(@NotNull String var1);
    }

    public static interface FeatureIdStage {
        public IdStage featureId(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public FeatureIdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(PlanEntitlementResponseData var1);
    }
}

