/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PlanGroupPlanDetailResponseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupDetailResponseData {
    private final List<PlanGroupPlanDetailResponseData> addOns;
    private final Optional<PlanGroupPlanDetailResponseData> defaultPlan;
    private final Optional<String> defaultPlanId;
    private final String id;
    private final List<PlanGroupPlanDetailResponseData> plans;
    private final Optional<Integer> trialDays;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private PlanGroupDetailResponseData(List<PlanGroupPlanDetailResponseData> addOns, Optional<PlanGroupPlanDetailResponseData> defaultPlan, Optional<String> defaultPlanId, String id, List<PlanGroupPlanDetailResponseData> plans, Optional<Integer> trialDays, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOns = addOns;
        this.defaultPlan = defaultPlan;
        this.defaultPlanId = defaultPlanId;
        this.id = id;
        this.plans = plans;
        this.trialDays = trialDays;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_ons")
    public List<PlanGroupPlanDetailResponseData> getAddOns() {
        return this.addOns;
    }

    @JsonProperty(value="default_plan")
    public Optional<PlanGroupPlanDetailResponseData> getDefaultPlan() {
        return this.defaultPlan;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plans")
    public List<PlanGroupPlanDetailResponseData> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupDetailResponseData && this.equalTo((PlanGroupDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupDetailResponseData other) {
        return this.addOns.equals(other.addOns) && this.defaultPlan.equals(other.defaultPlan) && this.defaultPlanId.equals(other.defaultPlanId) && this.id.equals(other.id) && this.plans.equals(other.plans) && this.trialDays.equals(other.trialDays) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.defaultPlan, this.defaultPlanId, this.id, this.plans, this.trialDays, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private List<PlanGroupPlanDetailResponseData> plans = new ArrayList<PlanGroupPlanDetailResponseData>();
        private Optional<String> defaultPlanId = Optional.empty();
        private Optional<PlanGroupPlanDetailResponseData> defaultPlan = Optional.empty();
        private List<PlanGroupPlanDetailResponseData> addOns = new ArrayList<PlanGroupPlanDetailResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupDetailResponseData other) {
            this.addOns(other.getAddOns());
            this.defaultPlan(other.getDefaultPlan());
            this.defaultPlanId(other.getDefaultPlanId());
            this.id(other.getId());
            this.plans(other.getPlans());
            this.trialDays(other.getTrialDays());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage addAllPlans(List<PlanGroupPlanDetailResponseData> plans) {
            this.plans.addAll(plans);
            return this;
        }

        @Override
        public _FinalStage addPlans(PlanGroupPlanDetailResponseData plans) {
            this.plans.add(plans);
            return this;
        }

        @Override
        @JsonSetter(value="plans", nulls=Nulls.SKIP)
        public _FinalStage plans(List<PlanGroupPlanDetailResponseData> plans) {
            this.plans.clear();
            this.plans.addAll(plans);
            return this;
        }

        @Override
        public _FinalStage defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        @Override
        public _FinalStage defaultPlan(PlanGroupPlanDetailResponseData defaultPlan) {
            this.defaultPlan = Optional.ofNullable(defaultPlan);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan", nulls=Nulls.SKIP)
        public _FinalStage defaultPlan(Optional<PlanGroupPlanDetailResponseData> defaultPlan) {
            this.defaultPlan = defaultPlan;
            return this;
        }

        @Override
        public _FinalStage addAllAddOns(List<PlanGroupPlanDetailResponseData> addOns) {
            this.addOns.addAll(addOns);
            return this;
        }

        @Override
        public _FinalStage addAddOns(PlanGroupPlanDetailResponseData addOns) {
            this.addOns.add(addOns);
            return this;
        }

        @Override
        @JsonSetter(value="add_ons", nulls=Nulls.SKIP)
        public _FinalStage addOns(List<PlanGroupPlanDetailResponseData> addOns) {
            this.addOns.clear();
            this.addOns.addAll(addOns);
            return this;
        }

        @Override
        public PlanGroupDetailResponseData build() {
            return new PlanGroupDetailResponseData(this.addOns, this.defaultPlan, this.defaultPlanId, this.id, this.plans, this.trialDays, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupDetailResponseData build();

        public _FinalStage addOns(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage addAddOns(PlanGroupPlanDetailResponseData var1);

        public _FinalStage addAllAddOns(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage defaultPlan(Optional<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage defaultPlan(PlanGroupPlanDetailResponseData var1);

        public _FinalStage defaultPlanId(Optional<String> var1);

        public _FinalStage defaultPlanId(String var1);

        public _FinalStage plans(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage addPlans(PlanGroupPlanDetailResponseData var1);

        public _FinalStage addAllPlans(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(PlanGroupDetailResponseData var1);
    }
}

