/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PreviewObject {
    private final Optional<String> description;
    private final String id;
    private final Optional<String> imageUrl;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private PreviewObject(Optional<String> description, String id, Optional<String> imageUrl, String name, Map<String, Object> additionalProperties) {
        this.description = description;
        this.id = id;
        this.imageUrl = imageUrl;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="image_url")
    public Optional<String> getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PreviewObject && this.equalTo((PreviewObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewObject other) {
        return this.description.equals(other.description) && this.id.equals(other.id) && this.imageUrl.equals(other.imageUrl) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.imageUrl, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<String> imageUrl = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PreviewObject other) {
            this.description(other.getDescription());
            this.id(other.getId());
            this.imageUrl(other.getImageUrl());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage imageUrl(String imageUrl) {
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        @Override
        @JsonSetter(value="image_url", nulls=Nulls.SKIP)
        public _FinalStage imageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public PreviewObject build() {
            return new PreviewObject(this.description, this.id, this.imageUrl, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PreviewObject build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage imageUrl(Optional<String> var1);

        public _FinalStage imageUrl(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(PreviewObject var1);
    }
}

