/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePayInAdvanceRequestBody {
    private final String priceId;
    private final int quantity;
    private final Map<String, Object> additionalProperties;

    private UpdatePayInAdvanceRequestBody(String priceId, int quantity, Map<String, Object> additionalProperties) {
        this.priceId = priceId;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="price_id")
    public String getPriceId() {
        return this.priceId;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePayInAdvanceRequestBody && this.equalTo((UpdatePayInAdvanceRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePayInAdvanceRequestBody other) {
        return this.priceId.equals(other.priceId) && this.quantity == other.quantity;
    }

    public int hashCode() {
        return Objects.hash(this.priceId, this.quantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PriceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PriceIdStage,
    QuantityStage,
    _FinalStage {
        private String priceId;
        private int quantity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePayInAdvanceRequestBody other) {
            this.priceId(other.getPriceId());
            this.quantity(other.getQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="price_id")
        public QuantityStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public UpdatePayInAdvanceRequestBody build() {
            return new UpdatePayInAdvanceRequestBody(this.priceId, this.quantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePayInAdvanceRequestBody build();
    }

    public static interface QuantityStage {
        public _FinalStage quantity(int var1);
    }

    public static interface PriceIdStage {
        public QuantityStage priceId(@NotNull String var1);

        public Builder from(UpdatePayInAdvanceRequestBody var1);
    }
}

