/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserResponseData {
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final String id;
    private final Optional<OffsetDateTime> lastSeenAt;
    private final String name;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private UserResponseData(OffsetDateTime createdAt, String environmentId, String id, Optional<OffsetDateTime> lastSeenAt, String name, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.id = id;
        this.lastSeenAt = lastSeenAt;
        this.name = name;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserResponseData && this.equalTo((UserResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.lastSeenAt.equals(other.lastSeenAt) && this.name.equals(other.name) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.environmentId, this.id, this.lastSeenAt, this.name, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UserResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.lastSeenAt(other.getLastSeenAt());
            this.name(other.getName());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public UserResponseData build() {
            return new UserResponseData(this.createdAt, this.environmentId, this.id, this.lastSeenAt, this.name, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UserResponseData build();

        public _FinalStage lastSeenAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAt(OffsetDateTime var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(UserResponseData var1);
    }
}

