/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api;

import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.RequestOptions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawBaseSchematic {
    protected final ClientOptions clientOptions;

    public AsyncRawBaseSchematic(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<BaseSchematicHttpResponse<Void>> putPlanAudiencesPlanAudienceId(String planAudienceId) {
        return this.putPlanAudiencesPlanAudienceId(planAudienceId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<Void>> putPlanAudiencesPlanAudienceId(String planAudienceId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-audiences").addPathSegment(planAudienceId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<BaseSchematicHttpResponse<Void>> future = new CompletableFuture<BaseSchematicHttpResponse<Void>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<Object>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<BaseSchematicHttpResponse<Void>> deletePlanAudiencesPlanAudienceId(String planAudienceId) {
        return this.deletePlanAudiencesPlanAudienceId(planAudienceId, null);
    }

    public CompletableFuture<BaseSchematicHttpResponse<Void>> deletePlanAudiencesPlanAudienceId(String planAudienceId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-audiences").addPathSegment(planAudienceId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<BaseSchematicHttpResponse<Void>> future = new CompletableFuture<BaseSchematicHttpResponse<Void>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new BaseSchematicHttpResponse<Object>(null, response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new BaseSchematicException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

