/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api;

import com.schematic.api.BaseSchematic;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.OkHttpClient;

public class BaseSchematicBuilder {
    private Optional<Integer> timeout = Optional.empty();
    private Optional<Integer> maxRetries = Optional.empty();
    private final Map<String, String> customHeaders = new HashMap<String, String>();
    private String apiKey = null;
    private Environment environment = Environment.DEFAULT;
    private OkHttpClient httpClient;

    public BaseSchematicBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public BaseSchematicBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public BaseSchematicBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public BaseSchematicBuilder timeout(int timeout) {
        this.timeout = Optional.of(timeout);
        return this;
    }

    public BaseSchematicBuilder maxRetries(int maxRetries) {
        this.maxRetries = Optional.of(maxRetries);
        return this;
    }

    public BaseSchematicBuilder httpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public BaseSchematicBuilder addHeader(String name, String value) {
        this.customHeaders.put(name, value);
        return this;
    }

    protected ClientOptions buildClientOptions() {
        ClientOptions.Builder builder = ClientOptions.builder();
        this.setEnvironment(builder);
        this.setAuthentication(builder);
        this.setHttpClient(builder);
        this.setTimeouts(builder);
        this.setRetries(builder);
        for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
            builder.addHeader(header.getKey(), header.getValue());
        }
        this.setAdditional(builder);
        return builder.build();
    }

    protected void setEnvironment(ClientOptions.Builder builder) {
        builder.environment(this.environment);
    }

    protected void setAuthentication(ClientOptions.Builder builder) {
        builder.addHeader("X-Schematic-Api-Key", this.apiKey);
    }

    protected void setTimeouts(ClientOptions.Builder builder) {
        if (this.timeout.isPresent()) {
            builder.timeout(this.timeout.get());
        }
    }

    protected void setRetries(ClientOptions.Builder builder) {
        if (this.maxRetries.isPresent()) {
            builder.maxRetries(this.maxRetries.get());
        }
    }

    protected void setHttpClient(ClientOptions.Builder builder) {
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
    }

    protected void setAdditional(ClientOptions.Builder builder) {
    }

    protected void validateConfiguration() {
    }

    public BaseSchematic build() {
        if (this.apiKey == null) {
            throw new RuntimeException("Please provide apiKey");
        }
        this.validateConfiguration();
        return new BaseSchematic(this.buildClientOptions());
    }
}

