/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.schematic.api.BaseSchematic;
import com.schematic.api.EventBuffer;
import com.schematic.api.cache.CacheProvider;
import com.schematic.api.cache.LocalCache;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.Environment;
import com.schematic.api.core.NoOpHttpClient;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.logger.ConsoleLogger;
import com.schematic.api.logger.SchematicLogger;
import com.schematic.api.resources.features.types.CheckFlagResponse;
import com.schematic.api.types.CheckFlagRequestBody;
import com.schematic.api.types.CreateEventRequestBody;
import com.schematic.api.types.CreateEventRequestBodyEventType;
import com.schematic.api.types.EventBody;
import com.schematic.api.types.EventBodyIdentify;
import com.schematic.api.types.EventBodyIdentifyCompany;
import com.schematic.api.types.EventBodyTrack;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Schematic
extends BaseSchematic
implements AutoCloseable {
    private final Duration eventBufferInterval;
    private final EventBuffer eventBuffer;
    private final List<CacheProvider<Boolean>> flagCheckCacheProviders;
    private final Map<String, Boolean> flagDefaults;
    private final SchematicLogger logger;
    private final String apiKey;
    private final Thread shutdownHook;
    private final boolean offline;

    private Schematic(Builder builder) {
        super(Schematic.buildClientOptions(builder.apiKey, builder));
        this.apiKey = builder.apiKey;
        this.eventBufferInterval = builder.eventBufferInterval != null ? builder.eventBufferInterval : Duration.ofMillis(5000L);
        this.logger = builder.logger != null ? builder.logger : new ConsoleLogger();
        this.flagDefaults = builder.flagDefaults != null ? builder.flagDefaults : new HashMap();
        this.offline = builder.offline;
        this.flagCheckCacheProviders = builder.cacheProviders != null ? builder.cacheProviders : Collections.singletonList(new LocalCache());
        this.eventBuffer = new EventBuffer(super.events(), this.logger, builder.eventBufferMaxSize, builder.eventBufferInterval != null ? builder.eventBufferInterval : Duration.ofMillis(5000L));
        this.shutdownHook = new Thread(() -> {
            try {
                this.eventBuffer.close();
            }
            catch (Exception e) {
                this.logger.error("Error during Schematic shutdown: " + e.getMessage(), new Object[0]);
            }
        }, "SchematicShutdownHook");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ClientOptions buildClientOptions(String apiKey, Builder builder) {
        String basePath = builder.basePath != null ? builder.basePath : "https://api.schematichq.com";
        ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder().environment(Environment.custom(basePath)).addHeader("X-Schematic-Api-Key", apiKey).addHeader("Content-Type", "application/json");
        if (builder.offline) {
            clientOptionsBuilder.httpClient(new NoOpHttpClient());
        }
        return clientOptionsBuilder.build();
    }

    public List<CacheProvider<Boolean>> getFlagCheckCacheProviders() {
        return this.flagCheckCacheProviders;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Duration getEventBufferInterval() {
        return this.eventBufferInterval;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean checkFlag(String flagKey, Map<String, String> company, Map<String, String> user) {
        if (this.offline) {
            return this.getFlagDefault(flagKey);
        }
        try {
            String cacheKey = this.buildCacheKey(flagKey, company, user);
            for (CacheProvider<Boolean> provider : this.flagCheckCacheProviders) {
                Boolean cachedValue = provider.get(cacheKey);
                if (cachedValue == null) continue;
                return cachedValue;
            }
            CheckFlagRequestBody request = CheckFlagRequestBody.builder().company(company).user(user).build();
            CheckFlagResponse response = this.features().checkFlag(flagKey, request);
            boolean value = response.getData().getValue();
            for (CacheProvider<Boolean> provider : this.flagCheckCacheProviders) {
                provider.set(cacheKey, value);
            }
            return value;
        }
        catch (Exception e) {
            this.logger.error("Error checking flag: " + e.getMessage(), new Object[0]);
            return this.getFlagDefault(flagKey);
        }
    }

    public void identify(Map<String, String> keys, EventBodyIdentifyCompany company, String name, Map<String, Object> traits) {
        if (this.offline) {
            return;
        }
        try {
            EventBodyIdentify body = EventBodyIdentify.builder().keys(keys).company(company).name(name).traits(this.objectMapToJsonNode(traits)).build();
            CreateEventRequestBody event = CreateEventRequestBody.builder().eventType(CreateEventRequestBodyEventType.IDENTIFY).body(EventBody.of(body)).sentAt(OffsetDateTime.now()).build();
            this.eventBuffer.push(event);
        }
        catch (Exception e) {
            this.logger.error("Error sending identify event: " + e.getMessage(), new Object[0]);
        }
    }

    public void track(String eventName, Map<String, String> company, Map<String, String> user, Map<String, Object> traits) {
        if (this.offline) {
            return;
        }
        try {
            EventBodyTrack body = EventBodyTrack.builder().event(eventName).company(company).user(user).traits(this.objectMapToJsonNode(traits)).build();
            CreateEventRequestBody event = CreateEventRequestBody.builder().eventType(CreateEventRequestBodyEventType.TRACK).body(EventBody.of(body)).sentAt(OffsetDateTime.now()).build();
            this.eventBuffer.push(event);
        }
        catch (Exception e) {
            this.logger.error("Error sending track event: " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void close() {
        try {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.eventBuffer.close();
        }
        catch (Exception e) {
            this.logger.error("Error closing Schematic client: " + e.getMessage(), new Object[0]);
        }
    }

    private boolean getFlagDefault(String flagKey) {
        return this.flagDefaults.getOrDefault(flagKey, false);
    }

    private String buildCacheKey(String flagKey, Map<String, String> company, Map<String, String> user) {
        StringBuilder key = new StringBuilder(flagKey);
        if (company != null && !company.isEmpty()) {
            key.append(":c-").append(this.serializeMap(company));
        }
        if (user != null && !user.isEmpty()) {
            key.append(":u-").append(this.serializeMap(user));
        }
        return key.toString();
    }

    private Map<String, JsonNode> objectMapToJsonNode(Map<String, Object> map) {
        HashMap<String, JsonNode> result = new HashMap<String, JsonNode>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), ObjectMappers.JSON_MAPPER.valueToTree(entry.getValue()));
        }
        return result;
    }

    private String serializeMap(Map<String, String> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
    }

    public static class Builder {
        private String apiKey;
        private SchematicLogger logger;
        private Map<String, Boolean> flagDefaults;
        private List<CacheProvider<Boolean>> cacheProviders;
        private boolean offline;
        private Duration eventBufferInterval;
        private int eventBufferMaxSize = 100;
        private String basePath;
        private Map<String, String> headers;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder logger(SchematicLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder flagDefaults(Map<String, Boolean> flagDefaults) {
            this.flagDefaults = flagDefaults;
            return this;
        }

        public Builder cacheProviders(List<CacheProvider<Boolean>> cacheProviders) {
            this.cacheProviders = cacheProviders;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder eventBufferInterval(Duration eventBufferInterval) {
            this.eventBufferInterval = eventBufferInterval;
            return this;
        }

        public Builder eventBufferMaxSize(int eventBufferMaxSize) {
            this.eventBufferMaxSize = eventBufferMaxSize;
            return this;
        }

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Schematic build() {
            if (this.apiKey == null) {
                throw new IllegalStateException("API key must be set");
            }
            return new Schematic(this);
        }
    }
}

