/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.cache;

import com.schematic.api.cache.CacheProvider;
import com.schematic.api.cache.CachedItem;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class LocalCache<T>
implements CacheProvider<T> {
    public static final int DEFAULT_CACHE_CAPACITY = 1000;
    public static final Duration DEFAULT_CACHE_TTL = Duration.ofMillis(5000L);
    private final ConcurrentHashMap<String, CachedItem<T>> cache = new ConcurrentHashMap();
    private final LinkedList<String> lruList = new LinkedList();
    private final ReentrantLock lock = new ReentrantLock();
    private final int maxItems;
    private final Duration ttl;

    public LocalCache() {
        this(1000, DEFAULT_CACHE_TTL);
    }

    public LocalCache(int maxItems, Duration ttl) {
        this.maxItems = maxItems;
        this.ttl = ttl;
    }

    @Override
    public T get(String key) {
        if (this.maxItems == 0) {
            return null;
        }
        CachedItem<T> item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        if (Instant.now().isAfter(item.getExpiration())) {
            this.remove(key);
            return null;
        }
        this.lock.lock();
        try {
            this.lruList.remove(item.getKey());
            this.lruList.addFirst(item.getKey());
        }
        finally {
            this.lock.unlock();
        }
        return item.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, T val, Duration ttlOverride) {
        if (this.maxItems == 0) {
            return;
        }
        Duration effectiveTtl = ttlOverride != null ? ttlOverride : this.ttl;
        Instant expiration = Instant.now().plus(effectiveTtl);
        this.lock.lock();
        try {
            CachedItem<T> existingItem = this.cache.get(key);
            if (existingItem != null) {
                existingItem.setValue(val);
                existingItem.setExpiration(expiration);
                this.lruList.remove(existingItem.getKey());
                this.lruList.addFirst(existingItem.getKey());
            } else {
                if (this.cache.size() >= this.maxItems) {
                    String lruKey = this.lruList.getLast();
                    this.remove(lruKey);
                }
                CachedItem<T> newItem = new CachedItem<T>(val, expiration, key);
                this.lruList.addFirst(key);
                this.cache.put(key, newItem);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void set(String key, T val) {
        this.set(key, val, null);
    }

    private void remove(String key) {
        CachedItem<T> removedItem = this.cache.remove(key);
        if (removedItem != null) {
            this.lock.lock();
            try {
                this.lruList.remove(removedItem.getKey());
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

