/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.accounts;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.accounts.RawAccountsClient;
import com.schematic.api.resources.accounts.requests.CountApiKeysRequest;
import com.schematic.api.resources.accounts.requests.CountApiRequestsRequest;
import com.schematic.api.resources.accounts.requests.CreateApiKeyRequestBody;
import com.schematic.api.resources.accounts.requests.CreateEnvironmentRequestBody;
import com.schematic.api.resources.accounts.requests.ListApiKeysRequest;
import com.schematic.api.resources.accounts.requests.ListApiRequestsRequest;
import com.schematic.api.resources.accounts.requests.ListEnvironmentsRequest;
import com.schematic.api.resources.accounts.requests.UpdateApiKeyRequestBody;
import com.schematic.api.resources.accounts.requests.UpdateEnvironmentRequestBody;
import com.schematic.api.resources.accounts.types.CountApiKeysResponse;
import com.schematic.api.resources.accounts.types.CountApiRequestsResponse;
import com.schematic.api.resources.accounts.types.CreateApiKeyResponse;
import com.schematic.api.resources.accounts.types.CreateEnvironmentResponse;
import com.schematic.api.resources.accounts.types.DeleteApiKeyResponse;
import com.schematic.api.resources.accounts.types.DeleteEnvironmentResponse;
import com.schematic.api.resources.accounts.types.GetApiKeyResponse;
import com.schematic.api.resources.accounts.types.GetApiRequestResponse;
import com.schematic.api.resources.accounts.types.GetEnvironmentResponse;
import com.schematic.api.resources.accounts.types.ListApiKeysResponse;
import com.schematic.api.resources.accounts.types.ListApiRequestsResponse;
import com.schematic.api.resources.accounts.types.ListEnvironmentsResponse;
import com.schematic.api.resources.accounts.types.QuickstartResponse;
import com.schematic.api.resources.accounts.types.UpdateApiKeyResponse;
import com.schematic.api.resources.accounts.types.UpdateEnvironmentResponse;

public class AccountsClient {
    protected final ClientOptions clientOptions;
    private final RawAccountsClient rawClient;

    public AccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAccountsClient(clientOptions);
    }

    public RawAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public ListApiKeysResponse listApiKeys(ListApiKeysRequest request) {
        return this.rawClient.listApiKeys(request).body();
    }

    public ListApiKeysResponse listApiKeys(ListApiKeysRequest request, RequestOptions requestOptions) {
        return this.rawClient.listApiKeys(request, requestOptions).body();
    }

    public CreateApiKeyResponse createApiKey(CreateApiKeyRequestBody request) {
        return this.rawClient.createApiKey(request).body();
    }

    public CreateApiKeyResponse createApiKey(CreateApiKeyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createApiKey(request, requestOptions).body();
    }

    public GetApiKeyResponse getApiKey(String apiKeyId) {
        return this.rawClient.getApiKey(apiKeyId).body();
    }

    public GetApiKeyResponse getApiKey(String apiKeyId, RequestOptions requestOptions) {
        return this.rawClient.getApiKey(apiKeyId, requestOptions).body();
    }

    public UpdateApiKeyResponse updateApiKey(String apiKeyId) {
        return this.rawClient.updateApiKey(apiKeyId).body();
    }

    public UpdateApiKeyResponse updateApiKey(String apiKeyId, UpdateApiKeyRequestBody request) {
        return this.rawClient.updateApiKey(apiKeyId, request).body();
    }

    public UpdateApiKeyResponse updateApiKey(String apiKeyId, UpdateApiKeyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateApiKey(apiKeyId, request, requestOptions).body();
    }

    public DeleteApiKeyResponse deleteApiKey(String apiKeyId) {
        return this.rawClient.deleteApiKey(apiKeyId).body();
    }

    public DeleteApiKeyResponse deleteApiKey(String apiKeyId, RequestOptions requestOptions) {
        return this.rawClient.deleteApiKey(apiKeyId, requestOptions).body();
    }

    public CountApiKeysResponse countApiKeys(CountApiKeysRequest request) {
        return this.rawClient.countApiKeys(request).body();
    }

    public CountApiKeysResponse countApiKeys(CountApiKeysRequest request, RequestOptions requestOptions) {
        return this.rawClient.countApiKeys(request, requestOptions).body();
    }

    public ListApiRequestsResponse listApiRequests() {
        return this.rawClient.listApiRequests().body();
    }

    public ListApiRequestsResponse listApiRequests(ListApiRequestsRequest request) {
        return this.rawClient.listApiRequests(request).body();
    }

    public ListApiRequestsResponse listApiRequests(ListApiRequestsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listApiRequests(request, requestOptions).body();
    }

    public GetApiRequestResponse getApiRequest(String apiRequestId) {
        return this.rawClient.getApiRequest(apiRequestId).body();
    }

    public GetApiRequestResponse getApiRequest(String apiRequestId, RequestOptions requestOptions) {
        return this.rawClient.getApiRequest(apiRequestId, requestOptions).body();
    }

    public CountApiRequestsResponse countApiRequests() {
        return this.rawClient.countApiRequests().body();
    }

    public CountApiRequestsResponse countApiRequests(CountApiRequestsRequest request) {
        return this.rawClient.countApiRequests(request).body();
    }

    public CountApiRequestsResponse countApiRequests(CountApiRequestsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countApiRequests(request, requestOptions).body();
    }

    public ListEnvironmentsResponse listEnvironments() {
        return this.rawClient.listEnvironments().body();
    }

    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest request) {
        return this.rawClient.listEnvironments(request).body();
    }

    public ListEnvironmentsResponse listEnvironments(ListEnvironmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEnvironments(request, requestOptions).body();
    }

    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequestBody request) {
        return this.rawClient.createEnvironment(request).body();
    }

    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEnvironment(request, requestOptions).body();
    }

    public GetEnvironmentResponse getEnvironment(String environmentId) {
        return this.rawClient.getEnvironment(environmentId).body();
    }

    public GetEnvironmentResponse getEnvironment(String environmentId, RequestOptions requestOptions) {
        return this.rawClient.getEnvironment(environmentId, requestOptions).body();
    }

    public UpdateEnvironmentResponse updateEnvironment(String environmentId) {
        return this.rawClient.updateEnvironment(environmentId).body();
    }

    public UpdateEnvironmentResponse updateEnvironment(String environmentId, UpdateEnvironmentRequestBody request) {
        return this.rawClient.updateEnvironment(environmentId, request).body();
    }

    public UpdateEnvironmentResponse updateEnvironment(String environmentId, UpdateEnvironmentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateEnvironment(environmentId, request, requestOptions).body();
    }

    public DeleteEnvironmentResponse deleteEnvironment(String environmentId) {
        return this.rawClient.deleteEnvironment(environmentId).body();
    }

    public DeleteEnvironmentResponse deleteEnvironment(String environmentId, RequestOptions requestOptions) {
        return this.rawClient.deleteEnvironment(environmentId, requestOptions).body();
    }

    public QuickstartResponse quickstart() {
        return this.rawClient.quickstart().body();
    }

    public QuickstartResponse quickstart(RequestOptions requestOptions) {
        return this.rawClient.quickstart(requestOptions).body();
    }
}

