/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.billing.AsyncRawBillingClient;
import com.schematic.api.resources.billing.requests.CountBillingProductsRequest;
import com.schematic.api.resources.billing.requests.CountCustomersRequest;
import com.schematic.api.resources.billing.requests.CreateBillingCustomerRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingPriceRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingProductRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingSubscriptionRequestBody;
import com.schematic.api.resources.billing.requests.CreateCouponRequestBody;
import com.schematic.api.resources.billing.requests.CreateInvoiceRequestBody;
import com.schematic.api.resources.billing.requests.CreateMeterRequestBody;
import com.schematic.api.resources.billing.requests.CreatePaymentMethodRequestBody;
import com.schematic.api.resources.billing.requests.ListBillingProductsRequest;
import com.schematic.api.resources.billing.requests.ListCouponsRequest;
import com.schematic.api.resources.billing.requests.ListCustomersWithSubscriptionsRequest;
import com.schematic.api.resources.billing.requests.ListInvoicesRequest;
import com.schematic.api.resources.billing.requests.ListMetersRequest;
import com.schematic.api.resources.billing.requests.ListPaymentMethodsRequest;
import com.schematic.api.resources.billing.requests.ListProductPricesRequest;
import com.schematic.api.resources.billing.requests.SearchBillingPricesRequest;
import com.schematic.api.resources.billing.types.CountBillingProductsResponse;
import com.schematic.api.resources.billing.types.CountCustomersResponse;
import com.schematic.api.resources.billing.types.DeleteBillingProductResponse;
import com.schematic.api.resources.billing.types.DeleteProductPriceResponse;
import com.schematic.api.resources.billing.types.ListBillingProductsResponse;
import com.schematic.api.resources.billing.types.ListCouponsResponse;
import com.schematic.api.resources.billing.types.ListCustomersWithSubscriptionsResponse;
import com.schematic.api.resources.billing.types.ListInvoicesResponse;
import com.schematic.api.resources.billing.types.ListMetersResponse;
import com.schematic.api.resources.billing.types.ListPaymentMethodsResponse;
import com.schematic.api.resources.billing.types.ListProductPricesResponse;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCouponResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCustomerResponse;
import com.schematic.api.resources.billing.types.UpsertBillingMeterResponse;
import com.schematic.api.resources.billing.types.UpsertBillingPriceResponse;
import com.schematic.api.resources.billing.types.UpsertBillingProductResponse;
import com.schematic.api.resources.billing.types.UpsertBillingSubscriptionResponse;
import com.schematic.api.resources.billing.types.UpsertInvoiceResponse;
import com.schematic.api.resources.billing.types.UpsertPaymentMethodResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncBillingClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBillingClient rawClient;

    public AsyncBillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBillingClient(clientOptions);
    }

    public AsyncRawBillingClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListCouponsResponse> listCoupons() {
        return this.rawClient.listCoupons().thenApply(response -> (ListCouponsResponse)response.body());
    }

    public CompletableFuture<ListCouponsResponse> listCoupons(ListCouponsRequest request) {
        return this.rawClient.listCoupons(request).thenApply(response -> (ListCouponsResponse)response.body());
    }

    public CompletableFuture<ListCouponsResponse> listCoupons(ListCouponsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCoupons(request, requestOptions).thenApply(response -> (ListCouponsResponse)response.body());
    }

    public CompletableFuture<UpsertBillingCouponResponse> upsertBillingCoupon(CreateCouponRequestBody request) {
        return this.rawClient.upsertBillingCoupon(request).thenApply(response -> (UpsertBillingCouponResponse)response.body());
    }

    public CompletableFuture<UpsertBillingCouponResponse> upsertBillingCoupon(CreateCouponRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingCoupon(request, requestOptions).thenApply(response -> (UpsertBillingCouponResponse)response.body());
    }

    public CompletableFuture<UpsertBillingCustomerResponse> upsertBillingCustomer(CreateBillingCustomerRequestBody request) {
        return this.rawClient.upsertBillingCustomer(request).thenApply(response -> (UpsertBillingCustomerResponse)response.body());
    }

    public CompletableFuture<UpsertBillingCustomerResponse> upsertBillingCustomer(CreateBillingCustomerRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingCustomer(request, requestOptions).thenApply(response -> (UpsertBillingCustomerResponse)response.body());
    }

    public CompletableFuture<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions() {
        return this.rawClient.listCustomersWithSubscriptions().thenApply(response -> (ListCustomersWithSubscriptionsResponse)response.body());
    }

    public CompletableFuture<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request) {
        return this.rawClient.listCustomersWithSubscriptions(request).thenApply(response -> (ListCustomersWithSubscriptionsResponse)response.body());
    }

    public CompletableFuture<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCustomersWithSubscriptions(request, requestOptions).thenApply(response -> (ListCustomersWithSubscriptionsResponse)response.body());
    }

    public CompletableFuture<CountCustomersResponse> countCustomers() {
        return this.rawClient.countCustomers().thenApply(response -> (CountCustomersResponse)response.body());
    }

    public CompletableFuture<CountCustomersResponse> countCustomers(CountCustomersRequest request) {
        return this.rawClient.countCustomers(request).thenApply(response -> (CountCustomersResponse)response.body());
    }

    public CompletableFuture<CountCustomersResponse> countCustomers(CountCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCustomers(request, requestOptions).thenApply(response -> (CountCustomersResponse)response.body());
    }

    public CompletableFuture<ListInvoicesResponse> listInvoices(ListInvoicesRequest request) {
        return this.rawClient.listInvoices(request).thenApply(response -> (ListInvoicesResponse)response.body());
    }

    public CompletableFuture<ListInvoicesResponse> listInvoices(ListInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listInvoices(request, requestOptions).thenApply(response -> (ListInvoicesResponse)response.body());
    }

    public CompletableFuture<UpsertInvoiceResponse> upsertInvoice(CreateInvoiceRequestBody request) {
        return this.rawClient.upsertInvoice(request).thenApply(response -> (UpsertInvoiceResponse)response.body());
    }

    public CompletableFuture<UpsertInvoiceResponse> upsertInvoice(CreateInvoiceRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertInvoice(request, requestOptions).thenApply(response -> (UpsertInvoiceResponse)response.body());
    }

    public CompletableFuture<ListMetersResponse> listMeters() {
        return this.rawClient.listMeters().thenApply(response -> (ListMetersResponse)response.body());
    }

    public CompletableFuture<ListMetersResponse> listMeters(ListMetersRequest request) {
        return this.rawClient.listMeters(request).thenApply(response -> (ListMetersResponse)response.body());
    }

    public CompletableFuture<ListMetersResponse> listMeters(ListMetersRequest request, RequestOptions requestOptions) {
        return this.rawClient.listMeters(request, requestOptions).thenApply(response -> (ListMetersResponse)response.body());
    }

    public CompletableFuture<UpsertBillingMeterResponse> upsertBillingMeter(CreateMeterRequestBody request) {
        return this.rawClient.upsertBillingMeter(request).thenApply(response -> (UpsertBillingMeterResponse)response.body());
    }

    public CompletableFuture<UpsertBillingMeterResponse> upsertBillingMeter(CreateMeterRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingMeter(request, requestOptions).thenApply(response -> (UpsertBillingMeterResponse)response.body());
    }

    public CompletableFuture<ListPaymentMethodsResponse> listPaymentMethods(ListPaymentMethodsRequest request) {
        return this.rawClient.listPaymentMethods(request).thenApply(response -> (ListPaymentMethodsResponse)response.body());
    }

    public CompletableFuture<ListPaymentMethodsResponse> listPaymentMethods(ListPaymentMethodsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPaymentMethods(request, requestOptions).thenApply(response -> (ListPaymentMethodsResponse)response.body());
    }

    public CompletableFuture<UpsertPaymentMethodResponse> upsertPaymentMethod(CreatePaymentMethodRequestBody request) {
        return this.rawClient.upsertPaymentMethod(request).thenApply(response -> (UpsertPaymentMethodResponse)response.body());
    }

    public CompletableFuture<UpsertPaymentMethodResponse> upsertPaymentMethod(CreatePaymentMethodRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertPaymentMethod(request, requestOptions).thenApply(response -> (UpsertPaymentMethodResponse)response.body());
    }

    public CompletableFuture<SearchBillingPricesResponse> searchBillingPrices() {
        return this.rawClient.searchBillingPrices().thenApply(response -> (SearchBillingPricesResponse)response.body());
    }

    public CompletableFuture<SearchBillingPricesResponse> searchBillingPrices(SearchBillingPricesRequest request) {
        return this.rawClient.searchBillingPrices(request).thenApply(response -> (SearchBillingPricesResponse)response.body());
    }

    public CompletableFuture<SearchBillingPricesResponse> searchBillingPrices(SearchBillingPricesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchBillingPrices(request, requestOptions).thenApply(response -> (SearchBillingPricesResponse)response.body());
    }

    public CompletableFuture<UpsertBillingPriceResponse> upsertBillingPrice(CreateBillingPriceRequestBody request) {
        return this.rawClient.upsertBillingPrice(request).thenApply(response -> (UpsertBillingPriceResponse)response.body());
    }

    public CompletableFuture<UpsertBillingPriceResponse> upsertBillingPrice(CreateBillingPriceRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingPrice(request, requestOptions).thenApply(response -> (UpsertBillingPriceResponse)response.body());
    }

    public CompletableFuture<DeleteBillingProductResponse> deleteBillingProduct(String billingId) {
        return this.rawClient.deleteBillingProduct(billingId).thenApply(response -> (DeleteBillingProductResponse)response.body());
    }

    public CompletableFuture<DeleteBillingProductResponse> deleteBillingProduct(String billingId, RequestOptions requestOptions) {
        return this.rawClient.deleteBillingProduct(billingId, requestOptions).thenApply(response -> (DeleteBillingProductResponse)response.body());
    }

    public CompletableFuture<ListProductPricesResponse> listProductPrices() {
        return this.rawClient.listProductPrices().thenApply(response -> (ListProductPricesResponse)response.body());
    }

    public CompletableFuture<ListProductPricesResponse> listProductPrices(ListProductPricesRequest request) {
        return this.rawClient.listProductPrices(request).thenApply(response -> (ListProductPricesResponse)response.body());
    }

    public CompletableFuture<ListProductPricesResponse> listProductPrices(ListProductPricesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listProductPrices(request, requestOptions).thenApply(response -> (ListProductPricesResponse)response.body());
    }

    public CompletableFuture<DeleteProductPriceResponse> deleteProductPrice(String billingId) {
        return this.rawClient.deleteProductPrice(billingId).thenApply(response -> (DeleteProductPriceResponse)response.body());
    }

    public CompletableFuture<DeleteProductPriceResponse> deleteProductPrice(String billingId, RequestOptions requestOptions) {
        return this.rawClient.deleteProductPrice(billingId, requestOptions).thenApply(response -> (DeleteProductPriceResponse)response.body());
    }

    public CompletableFuture<UpsertBillingProductResponse> upsertBillingProduct(CreateBillingProductRequestBody request) {
        return this.rawClient.upsertBillingProduct(request).thenApply(response -> (UpsertBillingProductResponse)response.body());
    }

    public CompletableFuture<UpsertBillingProductResponse> upsertBillingProduct(CreateBillingProductRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingProduct(request, requestOptions).thenApply(response -> (UpsertBillingProductResponse)response.body());
    }

    public CompletableFuture<ListBillingProductsResponse> listBillingProducts() {
        return this.rawClient.listBillingProducts().thenApply(response -> (ListBillingProductsResponse)response.body());
    }

    public CompletableFuture<ListBillingProductsResponse> listBillingProducts(ListBillingProductsRequest request) {
        return this.rawClient.listBillingProducts(request).thenApply(response -> (ListBillingProductsResponse)response.body());
    }

    public CompletableFuture<ListBillingProductsResponse> listBillingProducts(ListBillingProductsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingProducts(request, requestOptions).thenApply(response -> (ListBillingProductsResponse)response.body());
    }

    public CompletableFuture<CountBillingProductsResponse> countBillingProducts() {
        return this.rawClient.countBillingProducts().thenApply(response -> (CountBillingProductsResponse)response.body());
    }

    public CompletableFuture<CountBillingProductsResponse> countBillingProducts(CountBillingProductsRequest request) {
        return this.rawClient.countBillingProducts(request).thenApply(response -> (CountBillingProductsResponse)response.body());
    }

    public CompletableFuture<CountBillingProductsResponse> countBillingProducts(CountBillingProductsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingProducts(request, requestOptions).thenApply(response -> (CountBillingProductsResponse)response.body());
    }

    public CompletableFuture<UpsertBillingSubscriptionResponse> upsertBillingSubscription(CreateBillingSubscriptionRequestBody request) {
        return this.rawClient.upsertBillingSubscription(request).thenApply(response -> (UpsertBillingSubscriptionResponse)response.body());
    }

    public CompletableFuture<UpsertBillingSubscriptionResponse> upsertBillingSubscription(CreateBillingSubscriptionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingSubscription(request, requestOptions).thenApply(response -> (UpsertBillingSubscriptionResponse)response.body());
    }
}

