/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.billing.RawBillingClient;
import com.schematic.api.resources.billing.requests.CountBillingProductsRequest;
import com.schematic.api.resources.billing.requests.CountCustomersRequest;
import com.schematic.api.resources.billing.requests.CreateBillingCustomerRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingPriceRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingProductRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingSubscriptionRequestBody;
import com.schematic.api.resources.billing.requests.CreateCouponRequestBody;
import com.schematic.api.resources.billing.requests.CreateInvoiceRequestBody;
import com.schematic.api.resources.billing.requests.CreateMeterRequestBody;
import com.schematic.api.resources.billing.requests.CreatePaymentMethodRequestBody;
import com.schematic.api.resources.billing.requests.ListBillingProductsRequest;
import com.schematic.api.resources.billing.requests.ListCouponsRequest;
import com.schematic.api.resources.billing.requests.ListCustomersWithSubscriptionsRequest;
import com.schematic.api.resources.billing.requests.ListInvoicesRequest;
import com.schematic.api.resources.billing.requests.ListMetersRequest;
import com.schematic.api.resources.billing.requests.ListPaymentMethodsRequest;
import com.schematic.api.resources.billing.requests.ListProductPricesRequest;
import com.schematic.api.resources.billing.requests.SearchBillingPricesRequest;
import com.schematic.api.resources.billing.types.CountBillingProductsResponse;
import com.schematic.api.resources.billing.types.CountCustomersResponse;
import com.schematic.api.resources.billing.types.DeleteBillingProductResponse;
import com.schematic.api.resources.billing.types.DeleteProductPriceResponse;
import com.schematic.api.resources.billing.types.ListBillingProductsResponse;
import com.schematic.api.resources.billing.types.ListCouponsResponse;
import com.schematic.api.resources.billing.types.ListCustomersWithSubscriptionsResponse;
import com.schematic.api.resources.billing.types.ListInvoicesResponse;
import com.schematic.api.resources.billing.types.ListMetersResponse;
import com.schematic.api.resources.billing.types.ListPaymentMethodsResponse;
import com.schematic.api.resources.billing.types.ListProductPricesResponse;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCouponResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCustomerResponse;
import com.schematic.api.resources.billing.types.UpsertBillingMeterResponse;
import com.schematic.api.resources.billing.types.UpsertBillingPriceResponse;
import com.schematic.api.resources.billing.types.UpsertBillingProductResponse;
import com.schematic.api.resources.billing.types.UpsertBillingSubscriptionResponse;
import com.schematic.api.resources.billing.types.UpsertInvoiceResponse;
import com.schematic.api.resources.billing.types.UpsertPaymentMethodResponse;

public class BillingClient {
    protected final ClientOptions clientOptions;
    private final RawBillingClient rawClient;

    public BillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawBillingClient(clientOptions);
    }

    public RawBillingClient withRawResponse() {
        return this.rawClient;
    }

    public ListCouponsResponse listCoupons() {
        return this.rawClient.listCoupons().body();
    }

    public ListCouponsResponse listCoupons(ListCouponsRequest request) {
        return this.rawClient.listCoupons(request).body();
    }

    public ListCouponsResponse listCoupons(ListCouponsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCoupons(request, requestOptions).body();
    }

    public UpsertBillingCouponResponse upsertBillingCoupon(CreateCouponRequestBody request) {
        return this.rawClient.upsertBillingCoupon(request).body();
    }

    public UpsertBillingCouponResponse upsertBillingCoupon(CreateCouponRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingCoupon(request, requestOptions).body();
    }

    public UpsertBillingCustomerResponse upsertBillingCustomer(CreateBillingCustomerRequestBody request) {
        return this.rawClient.upsertBillingCustomer(request).body();
    }

    public UpsertBillingCustomerResponse upsertBillingCustomer(CreateBillingCustomerRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingCustomer(request, requestOptions).body();
    }

    public ListCustomersWithSubscriptionsResponse listCustomersWithSubscriptions() {
        return this.rawClient.listCustomersWithSubscriptions().body();
    }

    public ListCustomersWithSubscriptionsResponse listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request) {
        return this.rawClient.listCustomersWithSubscriptions(request).body();
    }

    public ListCustomersWithSubscriptionsResponse listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCustomersWithSubscriptions(request, requestOptions).body();
    }

    public CountCustomersResponse countCustomers() {
        return this.rawClient.countCustomers().body();
    }

    public CountCustomersResponse countCustomers(CountCustomersRequest request) {
        return this.rawClient.countCustomers(request).body();
    }

    public CountCustomersResponse countCustomers(CountCustomersRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCustomers(request, requestOptions).body();
    }

    public ListInvoicesResponse listInvoices(ListInvoicesRequest request) {
        return this.rawClient.listInvoices(request).body();
    }

    public ListInvoicesResponse listInvoices(ListInvoicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listInvoices(request, requestOptions).body();
    }

    public UpsertInvoiceResponse upsertInvoice(CreateInvoiceRequestBody request) {
        return this.rawClient.upsertInvoice(request).body();
    }

    public UpsertInvoiceResponse upsertInvoice(CreateInvoiceRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertInvoice(request, requestOptions).body();
    }

    public ListMetersResponse listMeters() {
        return this.rawClient.listMeters().body();
    }

    public ListMetersResponse listMeters(ListMetersRequest request) {
        return this.rawClient.listMeters(request).body();
    }

    public ListMetersResponse listMeters(ListMetersRequest request, RequestOptions requestOptions) {
        return this.rawClient.listMeters(request, requestOptions).body();
    }

    public UpsertBillingMeterResponse upsertBillingMeter(CreateMeterRequestBody request) {
        return this.rawClient.upsertBillingMeter(request).body();
    }

    public UpsertBillingMeterResponse upsertBillingMeter(CreateMeterRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingMeter(request, requestOptions).body();
    }

    public ListPaymentMethodsResponse listPaymentMethods(ListPaymentMethodsRequest request) {
        return this.rawClient.listPaymentMethods(request).body();
    }

    public ListPaymentMethodsResponse listPaymentMethods(ListPaymentMethodsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPaymentMethods(request, requestOptions).body();
    }

    public UpsertPaymentMethodResponse upsertPaymentMethod(CreatePaymentMethodRequestBody request) {
        return this.rawClient.upsertPaymentMethod(request).body();
    }

    public UpsertPaymentMethodResponse upsertPaymentMethod(CreatePaymentMethodRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertPaymentMethod(request, requestOptions).body();
    }

    public SearchBillingPricesResponse searchBillingPrices() {
        return this.rawClient.searchBillingPrices().body();
    }

    public SearchBillingPricesResponse searchBillingPrices(SearchBillingPricesRequest request) {
        return this.rawClient.searchBillingPrices(request).body();
    }

    public SearchBillingPricesResponse searchBillingPrices(SearchBillingPricesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchBillingPrices(request, requestOptions).body();
    }

    public UpsertBillingPriceResponse upsertBillingPrice(CreateBillingPriceRequestBody request) {
        return this.rawClient.upsertBillingPrice(request).body();
    }

    public UpsertBillingPriceResponse upsertBillingPrice(CreateBillingPriceRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingPrice(request, requestOptions).body();
    }

    public DeleteBillingProductResponse deleteBillingProduct(String billingId) {
        return this.rawClient.deleteBillingProduct(billingId).body();
    }

    public DeleteBillingProductResponse deleteBillingProduct(String billingId, RequestOptions requestOptions) {
        return this.rawClient.deleteBillingProduct(billingId, requestOptions).body();
    }

    public ListProductPricesResponse listProductPrices() {
        return this.rawClient.listProductPrices().body();
    }

    public ListProductPricesResponse listProductPrices(ListProductPricesRequest request) {
        return this.rawClient.listProductPrices(request).body();
    }

    public ListProductPricesResponse listProductPrices(ListProductPricesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listProductPrices(request, requestOptions).body();
    }

    public DeleteProductPriceResponse deleteProductPrice(String billingId) {
        return this.rawClient.deleteProductPrice(billingId).body();
    }

    public DeleteProductPriceResponse deleteProductPrice(String billingId, RequestOptions requestOptions) {
        return this.rawClient.deleteProductPrice(billingId, requestOptions).body();
    }

    public UpsertBillingProductResponse upsertBillingProduct(CreateBillingProductRequestBody request) {
        return this.rawClient.upsertBillingProduct(request).body();
    }

    public UpsertBillingProductResponse upsertBillingProduct(CreateBillingProductRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingProduct(request, requestOptions).body();
    }

    public ListBillingProductsResponse listBillingProducts() {
        return this.rawClient.listBillingProducts().body();
    }

    public ListBillingProductsResponse listBillingProducts(ListBillingProductsRequest request) {
        return this.rawClient.listBillingProducts(request).body();
    }

    public ListBillingProductsResponse listBillingProducts(ListBillingProductsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingProducts(request, requestOptions).body();
    }

    public CountBillingProductsResponse countBillingProducts() {
        return this.rawClient.countBillingProducts().body();
    }

    public CountBillingProductsResponse countBillingProducts(CountBillingProductsRequest request) {
        return this.rawClient.countBillingProducts(request).body();
    }

    public CountBillingProductsResponse countBillingProducts(CountBillingProductsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingProducts(request, requestOptions).body();
    }

    public UpsertBillingSubscriptionResponse upsertBillingSubscription(CreateBillingSubscriptionRequestBody request) {
        return this.rawClient.upsertBillingSubscription(request).body();
    }

    public UpsertBillingSubscriptionResponse upsertBillingSubscription(CreateBillingSubscriptionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingSubscription(request, requestOptions).body();
    }
}

