/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.billing.requests.CountBillingProductsRequest;
import com.schematic.api.resources.billing.requests.CountCustomersRequest;
import com.schematic.api.resources.billing.requests.CreateBillingCustomerRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingPriceRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingProductRequestBody;
import com.schematic.api.resources.billing.requests.CreateBillingSubscriptionRequestBody;
import com.schematic.api.resources.billing.requests.CreateCouponRequestBody;
import com.schematic.api.resources.billing.requests.CreateInvoiceRequestBody;
import com.schematic.api.resources.billing.requests.CreateMeterRequestBody;
import com.schematic.api.resources.billing.requests.CreatePaymentMethodRequestBody;
import com.schematic.api.resources.billing.requests.ListBillingProductsRequest;
import com.schematic.api.resources.billing.requests.ListCouponsRequest;
import com.schematic.api.resources.billing.requests.ListCustomersWithSubscriptionsRequest;
import com.schematic.api.resources.billing.requests.ListInvoicesRequest;
import com.schematic.api.resources.billing.requests.ListMetersRequest;
import com.schematic.api.resources.billing.requests.ListPaymentMethodsRequest;
import com.schematic.api.resources.billing.requests.ListProductPricesRequest;
import com.schematic.api.resources.billing.requests.SearchBillingPricesRequest;
import com.schematic.api.resources.billing.types.CountBillingProductsResponse;
import com.schematic.api.resources.billing.types.CountCustomersResponse;
import com.schematic.api.resources.billing.types.DeleteBillingProductResponse;
import com.schematic.api.resources.billing.types.DeleteProductPriceResponse;
import com.schematic.api.resources.billing.types.ListBillingProductsResponse;
import com.schematic.api.resources.billing.types.ListCouponsResponse;
import com.schematic.api.resources.billing.types.ListCustomersWithSubscriptionsResponse;
import com.schematic.api.resources.billing.types.ListInvoicesResponse;
import com.schematic.api.resources.billing.types.ListMetersResponse;
import com.schematic.api.resources.billing.types.ListPaymentMethodsResponse;
import com.schematic.api.resources.billing.types.ListProductPricesResponse;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCouponResponse;
import com.schematic.api.resources.billing.types.UpsertBillingCustomerResponse;
import com.schematic.api.resources.billing.types.UpsertBillingMeterResponse;
import com.schematic.api.resources.billing.types.UpsertBillingPriceResponse;
import com.schematic.api.resources.billing.types.UpsertBillingProductResponse;
import com.schematic.api.resources.billing.types.UpsertBillingSubscriptionResponse;
import com.schematic.api.resources.billing.types.UpsertInvoiceResponse;
import com.schematic.api.resources.billing.types.UpsertPaymentMethodResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawBillingClient {
    protected final ClientOptions clientOptions;

    public RawBillingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public BaseSchematicHttpResponse<ListCouponsResponse> listCoupons() {
        return this.listCoupons(ListCouponsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListCouponsResponse> listCoupons(ListCouponsRequest request) {
        return this.listCoupons(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListCouponsResponse> listCoupons(ListCouponsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/coupons");
        if (request.getIsActive().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "is_active", request.getIsActive().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListCouponsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListCouponsResponse>((ListCouponsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCouponsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingCouponResponse> upsertBillingCoupon(CreateCouponRequestBody request) {
        return this.upsertBillingCoupon(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingCouponResponse> upsertBillingCoupon(CreateCouponRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/coupons").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingCouponResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingCouponResponse>((UpsertBillingCouponResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingCouponResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingCustomerResponse> upsertBillingCustomer(CreateBillingCustomerRequestBody request) {
        return this.upsertBillingCustomer(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingCustomerResponse> upsertBillingCustomer(CreateBillingCustomerRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customer/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingCustomerResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingCustomerResponse>((UpsertBillingCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingCustomerResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions() {
        return this.listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request) {
        return this.listCustomersWithSubscriptions(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListCustomersWithSubscriptionsResponse> listCustomersWithSubscriptions(ListCustomersWithSubscriptionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customers");
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getFailedToImport().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "failed_to_import", request.getFailedToImport().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListCustomersWithSubscriptionsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListCustomersWithSubscriptionsResponse>((ListCustomersWithSubscriptionsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCustomersWithSubscriptionsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountCustomersResponse> countCustomers() {
        return this.countCustomers(CountCustomersRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountCustomersResponse> countCustomers(CountCustomersRequest request) {
        return this.countCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountCustomersResponse> countCustomers(CountCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/customers/count");
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getFailedToImport().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "failed_to_import", request.getFailedToImport().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountCustomersResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountCustomersResponse>((CountCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountCustomersResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListInvoicesResponse> listInvoices(ListInvoicesRequest request) {
        return this.listInvoices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListInvoicesResponse> listInvoices(ListInvoicesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/invoices");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        QueryStringMapper.addQueryParameter(httpUrl, "customer_external_id", request.getCustomerExternalId(), false);
        QueryStringMapper.addQueryParameter(httpUrl, "subscription_external_id", request.getSubscriptionExternalId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListInvoicesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListInvoicesResponse>((ListInvoicesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListInvoicesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertInvoiceResponse> upsertInvoice(CreateInvoiceRequestBody request) {
        return this.upsertInvoice(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertInvoiceResponse> upsertInvoice(CreateInvoiceRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/invoices").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertInvoiceResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertInvoiceResponse>((UpsertInvoiceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertInvoiceResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListMetersResponse> listMeters() {
        return this.listMeters(ListMetersRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListMetersResponse> listMeters(ListMetersRequest request) {
        return this.listMeters(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListMetersResponse> listMeters(ListMetersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/meter");
        if (request.getDisplayName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "display_name", request.getDisplayName().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListMetersResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListMetersResponse>((ListMetersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListMetersResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingMeterResponse> upsertBillingMeter(CreateMeterRequestBody request) {
        return this.upsertBillingMeter(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingMeterResponse> upsertBillingMeter(CreateMeterRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/meter/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingMeterResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingMeterResponse>((UpsertBillingMeterResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingMeterResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListPaymentMethodsResponse> listPaymentMethods(ListPaymentMethodsRequest request) {
        return this.listPaymentMethods(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListPaymentMethodsResponse> listPaymentMethods(ListPaymentMethodsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/payment-methods");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        QueryStringMapper.addQueryParameter(httpUrl, "customer_external_id", request.getCustomerExternalId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListPaymentMethodsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListPaymentMethodsResponse>((ListPaymentMethodsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPaymentMethodsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertPaymentMethodResponse> upsertPaymentMethod(CreatePaymentMethodRequestBody request) {
        return this.upsertPaymentMethod(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertPaymentMethodResponse> upsertPaymentMethod(CreatePaymentMethodRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/payment-methods").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertPaymentMethodResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertPaymentMethodResponse>((UpsertPaymentMethodResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertPaymentMethodResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<SearchBillingPricesResponse> searchBillingPrices() {
        return this.searchBillingPrices(SearchBillingPricesRequest.builder().build());
    }

    public BaseSchematicHttpResponse<SearchBillingPricesResponse> searchBillingPrices(SearchBillingPricesRequest request) {
        return this.searchBillingPrices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<SearchBillingPricesResponse> searchBillingPrices(SearchBillingPricesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/price");
        if (request.getForInitialPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_initial_plan", request.getForInitialPlan().get(), false);
        }
        if (request.getForTrialExpiryPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_trial_expiry_plan", request.getForTrialExpiryPlan().get(), false);
        }
        if (request.getProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "product_id", request.getProductId().get(), false);
        }
        if (request.getInterval().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "interval", request.getInterval().get(), false);
        }
        if (request.getPrice().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "price", request.getPrice().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getRequiresPaymentMethod().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "requires_payment_method", request.getRequiresPaymentMethod().get(), false);
        }
        if (request.getTiersMode().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "tiers_mode", request.getTiersMode().get(), false);
        }
        if (request.getUsageType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "usage_type", request.getUsageType().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<SearchBillingPricesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<SearchBillingPricesResponse>((SearchBillingPricesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchBillingPricesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingPriceResponse> upsertBillingPrice(CreateBillingPriceRequestBody request) {
        return this.upsertBillingPrice(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingPriceResponse> upsertBillingPrice(CreateBillingPriceRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/price/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingPriceResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingPriceResponse>((UpsertBillingPriceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingPriceResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeleteBillingProductResponse> deleteBillingProduct(String billingId) {
        return this.deleteBillingProduct(billingId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeleteBillingProductResponse> deleteBillingProduct(String billingId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product").addPathSegment(billingId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeleteBillingProductResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeleteBillingProductResponse>((DeleteBillingProductResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteBillingProductResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListProductPricesResponse> listProductPrices() {
        return this.listProductPrices(ListProductPricesRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListProductPricesResponse> listProductPrices(ListProductPricesRequest request) {
        return this.listProductPrices(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListProductPricesResponse> listProductPrices(ListProductPricesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/prices");
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getPriceUsageType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "price_usage_type", request.getPriceUsageType().get(), false);
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_linked_to_plan", request.getWithoutLinkedToPlan().get(), false);
        }
        if (request.getWithOneTimeCharges().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_one_time_charges", request.getWithOneTimeCharges().get(), false);
        }
        if (request.getWithZeroPrice().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_zero_price", request.getWithZeroPrice().get(), false);
        }
        if (request.getWithPricesOnly().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_prices_only", request.getWithPricesOnly().get(), false);
        }
        if (request.getIsActive().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "is_active", request.getIsActive().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListProductPricesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListProductPricesResponse>((ListProductPricesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListProductPricesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeleteProductPriceResponse> deleteProductPrice(String billingId) {
        return this.deleteProductPrice(billingId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeleteProductPriceResponse> deleteProductPrice(String billingId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/prices").addPathSegment(billingId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeleteProductPriceResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeleteProductPriceResponse>((DeleteProductPriceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteProductPriceResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingProductResponse> upsertBillingProduct(CreateBillingProductRequestBody request) {
        return this.upsertBillingProduct(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingProductResponse> upsertBillingProduct(CreateBillingProductRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/product/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingProductResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingProductResponse>((UpsertBillingProductResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingProductResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListBillingProductsResponse> listBillingProducts() {
        return this.listBillingProducts(ListBillingProductsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListBillingProductsResponse> listBillingProducts(ListBillingProductsRequest request) {
        return this.listBillingProducts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListBillingProductsResponse> listBillingProducts(ListBillingProductsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/products");
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getPriceUsageType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "price_usage_type", request.getPriceUsageType().get(), false);
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_linked_to_plan", request.getWithoutLinkedToPlan().get(), false);
        }
        if (request.getWithOneTimeCharges().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_one_time_charges", request.getWithOneTimeCharges().get(), false);
        }
        if (request.getWithZeroPrice().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_zero_price", request.getWithZeroPrice().get(), false);
        }
        if (request.getWithPricesOnly().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_prices_only", request.getWithPricesOnly().get(), false);
        }
        if (request.getIsActive().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "is_active", request.getIsActive().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListBillingProductsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListBillingProductsResponse>((ListBillingProductsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListBillingProductsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountBillingProductsResponse> countBillingProducts() {
        return this.countBillingProducts(CountBillingProductsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountBillingProductsResponse> countBillingProducts(CountBillingProductsRequest request) {
        return this.countBillingProducts(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountBillingProductsResponse> countBillingProducts(CountBillingProductsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/products/count");
        if (request.getName().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "name", request.getName().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getPriceUsageType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "price_usage_type", request.getPriceUsageType().get(), false);
        }
        if (request.getWithoutLinkedToPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_linked_to_plan", request.getWithoutLinkedToPlan().get(), false);
        }
        if (request.getWithOneTimeCharges().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_one_time_charges", request.getWithOneTimeCharges().get(), false);
        }
        if (request.getWithZeroPrice().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_zero_price", request.getWithZeroPrice().get(), false);
        }
        if (request.getWithPricesOnly().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_prices_only", request.getWithPricesOnly().get(), false);
        }
        if (request.getIsActive().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "is_active", request.getIsActive().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountBillingProductsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountBillingProductsResponse>((CountBillingProductsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountBillingProductsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingSubscriptionResponse> upsertBillingSubscription(CreateBillingSubscriptionRequestBody request) {
        return this.upsertBillingSubscription(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingSubscriptionResponse> upsertBillingSubscription(CreateBillingSubscriptionRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("billing/subscription/upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingSubscriptionResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingSubscriptionResponse>((UpsertBillingSubscriptionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingSubscriptionResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

