/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingCustomerRequestBody {
    private final Optional<String> companyId;
    private final Optional<String> defaultPaymentMethodId;
    private final String email;
    private final String externalId;
    private final boolean failedToImport;
    private final Map<String, String> meta;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private CreateBillingCustomerRequestBody(Optional<String> companyId, Optional<String> defaultPaymentMethodId, String email, String externalId, boolean failedToImport, Map<String, String> meta, String name, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        this.email = email;
        this.externalId = externalId;
        this.failedToImport = failedToImport;
        this.meta = meta;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="default_payment_method_id")
    public Optional<String> getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="failed_to_import")
    public boolean getFailedToImport() {
        return this.failedToImport;
    }

    @JsonProperty(value="meta")
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingCustomerRequestBody && this.equalTo((CreateBillingCustomerRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingCustomerRequestBody other) {
        return this.companyId.equals(other.companyId) && this.defaultPaymentMethodId.equals(other.defaultPaymentMethodId) && this.email.equals(other.email) && this.externalId.equals(other.externalId) && this.failedToImport == other.failedToImport && this.meta.equals(other.meta) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.defaultPaymentMethodId, this.email, this.externalId, this.failedToImport, this.meta, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EmailStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EmailStage,
    ExternalIdStage,
    FailedToImportStage,
    NameStage,
    _FinalStage {
        private String email;
        private String externalId;
        private boolean failedToImport;
        private String name;
        private Map<String, String> meta = new LinkedHashMap<String, String>();
        private Optional<String> defaultPaymentMethodId = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingCustomerRequestBody other) {
            this.companyId(other.getCompanyId());
            this.defaultPaymentMethodId(other.getDefaultPaymentMethodId());
            this.email(other.getEmail());
            this.externalId(other.getExternalId());
            this.failedToImport(other.getFailedToImport());
            this.meta(other.getMeta());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="email")
        public ExternalIdStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public FailedToImportStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="failed_to_import")
        public NameStage failedToImport(boolean failedToImport) {
            this.failedToImport = failedToImport;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage meta(String key, String value) {
            this.meta.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllMeta(Map<String, String> meta) {
            if (meta != null) {
                this.meta.putAll(meta);
            }
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Map<String, String> meta) {
            this.meta.clear();
            if (meta != null) {
                this.meta.putAll(meta);
            }
            return this;
        }

        @Override
        public _FinalStage defaultPaymentMethodId(String defaultPaymentMethodId) {
            this.defaultPaymentMethodId = Optional.ofNullable(defaultPaymentMethodId);
            return this;
        }

        @Override
        @JsonSetter(value="default_payment_method_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPaymentMethodId(Optional<String> defaultPaymentMethodId) {
            this.defaultPaymentMethodId = defaultPaymentMethodId;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public CreateBillingCustomerRequestBody build() {
            return new CreateBillingCustomerRequestBody(this.companyId, this.defaultPaymentMethodId, this.email, this.externalId, this.failedToImport, this.meta, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingCustomerRequestBody build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage defaultPaymentMethodId(Optional<String> var1);

        public _FinalStage defaultPaymentMethodId(String var1);

        public _FinalStage meta(Map<String, String> var1);

        public _FinalStage putAllMeta(Map<String, String> var1);

        public _FinalStage meta(String var1, String var2);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface FailedToImportStage {
        public NameStage failedToImport(boolean var1);
    }

    public static interface ExternalIdStage {
        public FailedToImportStage externalId(@NotNull String var1);
    }

    public static interface EmailStage {
        public ExternalIdStage email(@NotNull String var1);

        public Builder from(CreateBillingCustomerRequestBody var1);
    }
}

