/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.CreateBillingPriceRequestBodyBillingScheme;
import com.schematic.api.resources.billing.types.CreateBillingPriceRequestBodyTiersMode;
import com.schematic.api.resources.billing.types.CreateBillingPriceRequestBodyUsageType;
import com.schematic.api.types.CreateBillingPriceTierRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingPriceRequestBody {
    private final CreateBillingPriceRequestBodyBillingScheme billingScheme;
    private final String currency;
    private final String externalAccountId;
    private final String interval;
    private final boolean isActive;
    private final Optional<String> meterId;
    private final Optional<Integer> packageSize;
    private final int price;
    private final Optional<String> priceDecimal;
    private final String priceExternalId;
    private final List<CreateBillingPriceTierRequestBody> priceTiers;
    private final String productExternalId;
    private final Optional<CreateBillingPriceRequestBodyTiersMode> tiersMode;
    private final CreateBillingPriceRequestBodyUsageType usageType;
    private final Map<String, Object> additionalProperties;

    private CreateBillingPriceRequestBody(CreateBillingPriceRequestBodyBillingScheme billingScheme, String currency, String externalAccountId, String interval, boolean isActive, Optional<String> meterId, Optional<Integer> packageSize, int price, Optional<String> priceDecimal, String priceExternalId, List<CreateBillingPriceTierRequestBody> priceTiers, String productExternalId, Optional<CreateBillingPriceRequestBodyTiersMode> tiersMode, CreateBillingPriceRequestBodyUsageType usageType, Map<String, Object> additionalProperties) {
        this.billingScheme = billingScheme;
        this.currency = currency;
        this.externalAccountId = externalAccountId;
        this.interval = interval;
        this.isActive = isActive;
        this.meterId = meterId;
        this.packageSize = packageSize;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.priceExternalId = priceExternalId;
        this.priceTiers = priceTiers;
        this.productExternalId = productExternalId;
        this.tiersMode = tiersMode;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_scheme")
    public CreateBillingPriceRequestBodyBillingScheme getBillingScheme() {
        return this.billingScheme;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="external_account_id")
    public String getExternalAccountId() {
        return this.externalAccountId;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="package_size")
    public Optional<Integer> getPackageSize() {
        return this.packageSize;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_decimal")
    public Optional<String> getPriceDecimal() {
        return this.priceDecimal;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="price_tiers")
    public List<CreateBillingPriceTierRequestBody> getPriceTiers() {
        return this.priceTiers;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="tiers_mode")
    public Optional<CreateBillingPriceRequestBodyTiersMode> getTiersMode() {
        return this.tiersMode;
    }

    @JsonProperty(value="usage_type")
    public CreateBillingPriceRequestBodyUsageType getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingPriceRequestBody && this.equalTo((CreateBillingPriceRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPriceRequestBody other) {
        return this.billingScheme.equals(other.billingScheme) && this.currency.equals(other.currency) && this.externalAccountId.equals(other.externalAccountId) && this.interval.equals(other.interval) && this.isActive == other.isActive && this.meterId.equals(other.meterId) && this.packageSize.equals(other.packageSize) && this.price == other.price && this.priceDecimal.equals(other.priceDecimal) && this.priceExternalId.equals(other.priceExternalId) && this.priceTiers.equals(other.priceTiers) && this.productExternalId.equals(other.productExternalId) && this.tiersMode.equals(other.tiersMode) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.billingScheme, this.currency, this.externalAccountId, this.interval, this.isActive, this.meterId, this.packageSize, this.price, this.priceDecimal, this.priceExternalId, this.priceTiers, this.productExternalId, this.tiersMode, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingSchemeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BillingSchemeStage,
    CurrencyStage,
    ExternalAccountIdStage,
    IntervalStage,
    IsActiveStage,
    PriceStage,
    PriceExternalIdStage,
    ProductExternalIdStage,
    UsageTypeStage,
    _FinalStage {
        private CreateBillingPriceRequestBodyBillingScheme billingScheme;
        private String currency;
        private String externalAccountId;
        private String interval;
        private boolean isActive;
        private int price;
        private String priceExternalId;
        private String productExternalId;
        private CreateBillingPriceRequestBodyUsageType usageType;
        private Optional<CreateBillingPriceRequestBodyTiersMode> tiersMode = Optional.empty();
        private List<CreateBillingPriceTierRequestBody> priceTiers = new ArrayList<CreateBillingPriceTierRequestBody>();
        private Optional<String> priceDecimal = Optional.empty();
        private Optional<Integer> packageSize = Optional.empty();
        private Optional<String> meterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingPriceRequestBody other) {
            this.billingScheme(other.getBillingScheme());
            this.currency(other.getCurrency());
            this.externalAccountId(other.getExternalAccountId());
            this.interval(other.getInterval());
            this.isActive(other.getIsActive());
            this.meterId(other.getMeterId());
            this.packageSize(other.getPackageSize());
            this.price(other.getPrice());
            this.priceDecimal(other.getPriceDecimal());
            this.priceExternalId(other.getPriceExternalId());
            this.priceTiers(other.getPriceTiers());
            this.productExternalId(other.getProductExternalId());
            this.tiersMode(other.getTiersMode());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="billing_scheme")
        public CurrencyStage billingScheme(@NotNull CreateBillingPriceRequestBodyBillingScheme billingScheme) {
            this.billingScheme = Objects.requireNonNull(billingScheme, "billingScheme must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public ExternalAccountIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_account_id")
        public IntervalStage externalAccountId(@NotNull String externalAccountId) {
            this.externalAccountId = Objects.requireNonNull(externalAccountId, "externalAccountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public PriceStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public UsageTypeStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull CreateBillingPriceRequestBodyUsageType usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage tiersMode(CreateBillingPriceRequestBodyTiersMode tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @Override
        @JsonSetter(value="tiers_mode", nulls=Nulls.SKIP)
        public _FinalStage tiersMode(Optional<CreateBillingPriceRequestBodyTiersMode> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        @Override
        public _FinalStage addAllPriceTiers(List<CreateBillingPriceTierRequestBody> priceTiers) {
            if (priceTiers != null) {
                this.priceTiers.addAll(priceTiers);
            }
            return this;
        }

        @Override
        public _FinalStage addPriceTiers(CreateBillingPriceTierRequestBody priceTiers) {
            this.priceTiers.add(priceTiers);
            return this;
        }

        @Override
        @JsonSetter(value="price_tiers", nulls=Nulls.SKIP)
        public _FinalStage priceTiers(List<CreateBillingPriceTierRequestBody> priceTiers) {
            this.priceTiers.clear();
            if (priceTiers != null) {
                this.priceTiers.addAll(priceTiers);
            }
            return this;
        }

        @Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @Override
        @JsonSetter(value="price_decimal", nulls=Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @Override
        public _FinalStage packageSize(Integer packageSize) {
            this.packageSize = Optional.ofNullable(packageSize);
            return this;
        }

        @Override
        @JsonSetter(value="package_size", nulls=Nulls.SKIP)
        public _FinalStage packageSize(Optional<Integer> packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public CreateBillingPriceRequestBody build() {
            return new CreateBillingPriceRequestBody(this.billingScheme, this.currency, this.externalAccountId, this.interval, this.isActive, this.meterId, this.packageSize, this.price, this.priceDecimal, this.priceExternalId, this.priceTiers, this.productExternalId, this.tiersMode, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingPriceRequestBody build();

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);

        public _FinalStage packageSize(Optional<Integer> var1);

        public _FinalStage packageSize(Integer var1);

        public _FinalStage priceDecimal(Optional<String> var1);

        public _FinalStage priceDecimal(String var1);

        public _FinalStage priceTiers(List<CreateBillingPriceTierRequestBody> var1);

        public _FinalStage addPriceTiers(CreateBillingPriceTierRequestBody var1);

        public _FinalStage addAllPriceTiers(List<CreateBillingPriceTierRequestBody> var1);

        public _FinalStage tiersMode(Optional<CreateBillingPriceRequestBodyTiersMode> var1);

        public _FinalStage tiersMode(CreateBillingPriceRequestBodyTiersMode var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull CreateBillingPriceRequestBodyUsageType var1);
    }

    public static interface ProductExternalIdStage {
        public UsageTypeStage productExternalId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public ProductExternalIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface IsActiveStage {
        public PriceStage isActive(boolean var1);
    }

    public static interface IntervalStage {
        public IsActiveStage interval(@NotNull String var1);
    }

    public static interface ExternalAccountIdStage {
        public IntervalStage externalAccountId(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public ExternalAccountIdStage currency(@NotNull String var1);
    }

    public static interface BillingSchemeStage {
        public CurrencyStage billingScheme(@NotNull CreateBillingPriceRequestBodyBillingScheme var1);

        public Builder from(CreateBillingPriceRequestBody var1);
    }
}

