/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingProductRequestBody {
    private final String externalId;
    private final Optional<Boolean> isActive;
    private final String name;
    private final double price;
    private final Map<String, Object> additionalProperties;

    private CreateBillingProductRequestBody(String externalId, Optional<Boolean> isActive, String name, double price, Map<String, Object> additionalProperties) {
        this.externalId = externalId;
        this.isActive = isActive;
        this.name = name;
        this.price = price;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="is_active")
    public Optional<Boolean> getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public double getPrice() {
        return this.price;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingProductRequestBody && this.equalTo((CreateBillingProductRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingProductRequestBody other) {
        return this.externalId.equals(other.externalId) && this.isActive.equals(other.isActive) && this.name.equals(other.name) && this.price == other.price;
    }

    public int hashCode() {
        return Objects.hash(this.externalId, this.isActive, this.name, this.price);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ExternalIdStage,
    NameStage,
    PriceStage,
    _FinalStage {
        private String externalId;
        private String name;
        private double price;
        private Optional<Boolean> isActive = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingProductRequestBody other) {
            this.externalId(other.getExternalId());
            this.isActive(other.getIsActive());
            this.name(other.getName());
            this.price(other.getPrice());
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public NameStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public _FinalStage price(double price) {
            this.price = price;
            return this;
        }

        @Override
        public _FinalStage isActive(Boolean isActive) {
            this.isActive = Optional.ofNullable(isActive);
            return this;
        }

        @Override
        @JsonSetter(value="is_active", nulls=Nulls.SKIP)
        public _FinalStage isActive(Optional<Boolean> isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public CreateBillingProductRequestBody build() {
            return new CreateBillingProductRequestBody(this.externalId, this.isActive, this.name, this.price, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingProductRequestBody build();

        public _FinalStage isActive(Optional<Boolean> var1);

        public _FinalStage isActive(Boolean var1);
    }

    public static interface PriceStage {
        public _FinalStage price(double var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface ExternalIdStage {
        public NameStage externalId(@NotNull String var1);

        public Builder from(CreateBillingProductRequestBody var1);
    }
}

