/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.SearchBillingPricesRequestTiersMode;
import com.schematic.api.resources.billing.types.SearchBillingPricesRequestUsageType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchBillingPricesRequest {
    private final Optional<List<String>> ids;
    private final Optional<Boolean> forInitialPlan;
    private final Optional<Boolean> forTrialExpiryPlan;
    private final Optional<String> productId;
    private final Optional<String> interval;
    private final Optional<Integer> price;
    private final Optional<String> q;
    private final Optional<Boolean> requiresPaymentMethod;
    private final Optional<SearchBillingPricesRequestTiersMode> tiersMode;
    private final Optional<SearchBillingPricesRequestUsageType> usageType;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private SearchBillingPricesRequest(Optional<List<String>> ids, Optional<Boolean> forInitialPlan, Optional<Boolean> forTrialExpiryPlan, Optional<String> productId, Optional<String> interval, Optional<Integer> price, Optional<String> q, Optional<Boolean> requiresPaymentMethod, Optional<SearchBillingPricesRequestTiersMode> tiersMode, Optional<SearchBillingPricesRequestUsageType> usageType, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.forInitialPlan = forInitialPlan;
        this.forTrialExpiryPlan = forTrialExpiryPlan;
        this.productId = productId;
        this.interval = interval;
        this.price = price;
        this.q = q;
        this.requiresPaymentMethod = requiresPaymentMethod;
        this.tiersMode = tiersMode;
        this.usageType = usageType;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="for_initial_plan")
    public Optional<Boolean> getForInitialPlan() {
        return this.forInitialPlan;
    }

    @JsonProperty(value="for_trial_expiry_plan")
    public Optional<Boolean> getForTrialExpiryPlan() {
        return this.forTrialExpiryPlan;
    }

    @JsonProperty(value="product_id")
    public Optional<String> getProductId() {
        return this.productId;
    }

    @JsonProperty(value="interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="price")
    public Optional<Integer> getPrice() {
        return this.price;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="requires_payment_method")
    public Optional<Boolean> getRequiresPaymentMethod() {
        return this.requiresPaymentMethod;
    }

    @JsonProperty(value="tiers_mode")
    public Optional<SearchBillingPricesRequestTiersMode> getTiersMode() {
        return this.tiersMode;
    }

    @JsonProperty(value="usage_type")
    public Optional<SearchBillingPricesRequestUsageType> getUsageType() {
        return this.usageType;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchBillingPricesRequest && this.equalTo((SearchBillingPricesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchBillingPricesRequest other) {
        return this.ids.equals(other.ids) && this.forInitialPlan.equals(other.forInitialPlan) && this.forTrialExpiryPlan.equals(other.forTrialExpiryPlan) && this.productId.equals(other.productId) && this.interval.equals(other.interval) && this.price.equals(other.price) && this.q.equals(other.q) && this.requiresPaymentMethod.equals(other.requiresPaymentMethod) && this.tiersMode.equals(other.tiersMode) && this.usageType.equals(other.usageType) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.forInitialPlan, this.forTrialExpiryPlan, this.productId, this.interval, this.price, this.q, this.requiresPaymentMethod, this.tiersMode, this.usageType, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();
        private Optional<Boolean> forInitialPlan = Optional.empty();
        private Optional<Boolean> forTrialExpiryPlan = Optional.empty();
        private Optional<String> productId = Optional.empty();
        private Optional<String> interval = Optional.empty();
        private Optional<Integer> price = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<Boolean> requiresPaymentMethod = Optional.empty();
        private Optional<SearchBillingPricesRequestTiersMode> tiersMode = Optional.empty();
        private Optional<SearchBillingPricesRequestUsageType> usageType = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchBillingPricesRequest other) {
            this.ids(other.getIds());
            this.forInitialPlan(other.getForInitialPlan());
            this.forTrialExpiryPlan(other.getForTrialExpiryPlan());
            this.productId(other.getProductId());
            this.interval(other.getInterval());
            this.price(other.getPrice());
            this.q(other.getQ());
            this.requiresPaymentMethod(other.getRequiresPaymentMethod());
            this.tiersMode(other.getTiersMode());
            this.usageType(other.getUsageType());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        @JsonSetter(value="for_initial_plan", nulls=Nulls.SKIP)
        public Builder forInitialPlan(Optional<Boolean> forInitialPlan) {
            this.forInitialPlan = forInitialPlan;
            return this;
        }

        public Builder forInitialPlan(Boolean forInitialPlan) {
            this.forInitialPlan = Optional.ofNullable(forInitialPlan);
            return this;
        }

        @JsonSetter(value="for_trial_expiry_plan", nulls=Nulls.SKIP)
        public Builder forTrialExpiryPlan(Optional<Boolean> forTrialExpiryPlan) {
            this.forTrialExpiryPlan = forTrialExpiryPlan;
            return this;
        }

        public Builder forTrialExpiryPlan(Boolean forTrialExpiryPlan) {
            this.forTrialExpiryPlan = Optional.ofNullable(forTrialExpiryPlan);
            return this;
        }

        @JsonSetter(value="product_id", nulls=Nulls.SKIP)
        public Builder productId(Optional<String> productId) {
            this.productId = productId;
            return this;
        }

        public Builder productId(String productId) {
            this.productId = Optional.ofNullable(productId);
            return this;
        }

        @JsonSetter(value="interval", nulls=Nulls.SKIP)
        public Builder interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public Builder price(Optional<Integer> price) {
            this.price = price;
            return this;
        }

        public Builder price(Integer price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="requires_payment_method", nulls=Nulls.SKIP)
        public Builder requiresPaymentMethod(Optional<Boolean> requiresPaymentMethod) {
            this.requiresPaymentMethod = requiresPaymentMethod;
            return this;
        }

        public Builder requiresPaymentMethod(Boolean requiresPaymentMethod) {
            this.requiresPaymentMethod = Optional.ofNullable(requiresPaymentMethod);
            return this;
        }

        @JsonSetter(value="tiers_mode", nulls=Nulls.SKIP)
        public Builder tiersMode(Optional<SearchBillingPricesRequestTiersMode> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        public Builder tiersMode(SearchBillingPricesRequestTiersMode tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @JsonSetter(value="usage_type", nulls=Nulls.SKIP)
        public Builder usageType(Optional<SearchBillingPricesRequestUsageType> usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder usageType(SearchBillingPricesRequestUsageType usageType) {
            this.usageType = Optional.ofNullable(usageType);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public SearchBillingPricesRequest build() {
            return new SearchBillingPricesRequest(this.ids, this.forInitialPlan, this.forTrialExpiryPlan, this.productId, this.interval, this.price, this.q, this.requiresPaymentMethod, this.tiersMode, this.usageType, this.limit, this.offset, this.additionalProperties);
        }
    }
}

