/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponseParamsTiersMode;
import com.schematic.api.resources.billing.types.SearchBillingPricesResponseParamsUsageType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchBillingPricesParams {
    private final Optional<Boolean> forInitialPlan;
    private final Optional<Boolean> forTrialExpiryPlan;
    private final Optional<List<String>> ids;
    private final Optional<String> interval;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<Integer> price;
    private final Optional<String> productId;
    private final Optional<String> q;
    private final Optional<Boolean> requiresPaymentMethod;
    private final Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode;
    private final Optional<SearchBillingPricesResponseParamsUsageType> usageType;
    private final Map<String, Object> additionalProperties;

    private SearchBillingPricesParams(Optional<Boolean> forInitialPlan, Optional<Boolean> forTrialExpiryPlan, Optional<List<String>> ids, Optional<String> interval, Optional<Integer> limit, Optional<Integer> offset, Optional<Integer> price, Optional<String> productId, Optional<String> q, Optional<Boolean> requiresPaymentMethod, Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode, Optional<SearchBillingPricesResponseParamsUsageType> usageType, Map<String, Object> additionalProperties) {
        this.forInitialPlan = forInitialPlan;
        this.forTrialExpiryPlan = forTrialExpiryPlan;
        this.ids = ids;
        this.interval = interval;
        this.limit = limit;
        this.offset = offset;
        this.price = price;
        this.productId = productId;
        this.q = q;
        this.requiresPaymentMethod = requiresPaymentMethod;
        this.tiersMode = tiersMode;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="for_initial_plan")
    public Optional<Boolean> getForInitialPlan() {
        return this.forInitialPlan;
    }

    @JsonProperty(value="for_trial_expiry_plan")
    public Optional<Boolean> getForTrialExpiryPlan() {
        return this.forTrialExpiryPlan;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="interval")
    public Optional<String> getInterval() {
        return this.interval;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="price")
    public Optional<Integer> getPrice() {
        return this.price;
    }

    @JsonProperty(value="product_id")
    public Optional<String> getProductId() {
        return this.productId;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="requires_payment_method")
    public Optional<Boolean> getRequiresPaymentMethod() {
        return this.requiresPaymentMethod;
    }

    @JsonProperty(value="tiers_mode")
    public Optional<SearchBillingPricesResponseParamsTiersMode> getTiersMode() {
        return this.tiersMode;
    }

    @JsonProperty(value="usage_type")
    public Optional<SearchBillingPricesResponseParamsUsageType> getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchBillingPricesParams && this.equalTo((SearchBillingPricesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchBillingPricesParams other) {
        return this.forInitialPlan.equals(other.forInitialPlan) && this.forTrialExpiryPlan.equals(other.forTrialExpiryPlan) && this.ids.equals(other.ids) && this.interval.equals(other.interval) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.price.equals(other.price) && this.productId.equals(other.productId) && this.q.equals(other.q) && this.requiresPaymentMethod.equals(other.requiresPaymentMethod) && this.tiersMode.equals(other.tiersMode) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.forInitialPlan, this.forTrialExpiryPlan, this.ids, this.interval, this.limit, this.offset, this.price, this.productId, this.q, this.requiresPaymentMethod, this.tiersMode, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> forInitialPlan = Optional.empty();
        private Optional<Boolean> forTrialExpiryPlan = Optional.empty();
        private Optional<List<String>> ids = Optional.empty();
        private Optional<String> interval = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> price = Optional.empty();
        private Optional<String> productId = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<Boolean> requiresPaymentMethod = Optional.empty();
        private Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode = Optional.empty();
        private Optional<SearchBillingPricesResponseParamsUsageType> usageType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchBillingPricesParams other) {
            this.forInitialPlan(other.getForInitialPlan());
            this.forTrialExpiryPlan(other.getForTrialExpiryPlan());
            this.ids(other.getIds());
            this.interval(other.getInterval());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.price(other.getPrice());
            this.productId(other.getProductId());
            this.q(other.getQ());
            this.requiresPaymentMethod(other.getRequiresPaymentMethod());
            this.tiersMode(other.getTiersMode());
            this.usageType(other.getUsageType());
            return this;
        }

        @JsonSetter(value="for_initial_plan", nulls=Nulls.SKIP)
        public Builder forInitialPlan(Optional<Boolean> forInitialPlan) {
            this.forInitialPlan = forInitialPlan;
            return this;
        }

        public Builder forInitialPlan(Boolean forInitialPlan) {
            this.forInitialPlan = Optional.ofNullable(forInitialPlan);
            return this;
        }

        @JsonSetter(value="for_trial_expiry_plan", nulls=Nulls.SKIP)
        public Builder forTrialExpiryPlan(Optional<Boolean> forTrialExpiryPlan) {
            this.forTrialExpiryPlan = forTrialExpiryPlan;
            return this;
        }

        public Builder forTrialExpiryPlan(Boolean forTrialExpiryPlan) {
            this.forTrialExpiryPlan = Optional.ofNullable(forTrialExpiryPlan);
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="interval", nulls=Nulls.SKIP)
        public Builder interval(Optional<String> interval) {
            this.interval = interval;
            return this;
        }

        public Builder interval(String interval) {
            this.interval = Optional.ofNullable(interval);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public Builder price(Optional<Integer> price) {
            this.price = price;
            return this;
        }

        public Builder price(Integer price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @JsonSetter(value="product_id", nulls=Nulls.SKIP)
        public Builder productId(Optional<String> productId) {
            this.productId = productId;
            return this;
        }

        public Builder productId(String productId) {
            this.productId = Optional.ofNullable(productId);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="requires_payment_method", nulls=Nulls.SKIP)
        public Builder requiresPaymentMethod(Optional<Boolean> requiresPaymentMethod) {
            this.requiresPaymentMethod = requiresPaymentMethod;
            return this;
        }

        public Builder requiresPaymentMethod(Boolean requiresPaymentMethod) {
            this.requiresPaymentMethod = Optional.ofNullable(requiresPaymentMethod);
            return this;
        }

        @JsonSetter(value="tiers_mode", nulls=Nulls.SKIP)
        public Builder tiersMode(Optional<SearchBillingPricesResponseParamsTiersMode> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        public Builder tiersMode(SearchBillingPricesResponseParamsTiersMode tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @JsonSetter(value="usage_type", nulls=Nulls.SKIP)
        public Builder usageType(Optional<SearchBillingPricesResponseParamsUsageType> usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder usageType(SearchBillingPricesResponseParamsUsageType usageType) {
            this.usageType = Optional.ofNullable(usageType);
            return this;
        }

        public SearchBillingPricesParams build() {
            return new SearchBillingPricesParams(this.forInitialPlan, this.forTrialExpiryPlan, this.ids, this.interval, this.limit, this.offset, this.price, this.productId, this.q, this.requiresPaymentMethod, this.tiersMode, this.usageType, this.additionalProperties);
        }
    }
}

