/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.companies.AsyncRawCompaniesClient;
import com.schematic.api.resources.companies.requests.CountCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.CountCompaniesRequest;
import com.schematic.api.resources.companies.requests.CountEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.CountUsersRequest;
import com.schematic.api.resources.companies.requests.CreateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.CreatePlanTraitRequestBody;
import com.schematic.api.resources.companies.requests.GetActiveCompanySubscriptionRequest;
import com.schematic.api.resources.companies.requests.GetActiveDealsRequest;
import com.schematic.api.resources.companies.requests.GetEntityTraitValuesRequest;
import com.schematic.api.resources.companies.requests.GetOrCreateCompanyMembershipRequestBody;
import com.schematic.api.resources.companies.requests.ListCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.ListCompaniesRequest;
import com.schematic.api.resources.companies.requests.ListCompanyMembershipsRequest;
import com.schematic.api.resources.companies.requests.ListEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListPlanChangesRequest;
import com.schematic.api.resources.companies.requests.ListPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.ListUsersRequest;
import com.schematic.api.resources.companies.requests.LookupCompanyRequest;
import com.schematic.api.resources.companies.requests.LookupUserRequest;
import com.schematic.api.resources.companies.requests.UpdateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitBulkRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitRequestBody;
import com.schematic.api.resources.companies.types.CountCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.CountCompaniesResponse;
import com.schematic.api.resources.companies.types.CountEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountPlanTraitsResponse;
import com.schematic.api.resources.companies.types.CountUsersResponse;
import com.schematic.api.resources.companies.types.CreateCompanyResponse;
import com.schematic.api.resources.companies.types.CreatePlanTraitResponse;
import com.schematic.api.resources.companies.types.CreateUserResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyResponse;
import com.schematic.api.resources.companies.types.DeletePlanTraitResponse;
import com.schematic.api.resources.companies.types.DeleteUserByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteUserResponse;
import com.schematic.api.resources.companies.types.GetActiveCompanySubscriptionResponse;
import com.schematic.api.resources.companies.types.GetActiveDealsResponse;
import com.schematic.api.resources.companies.types.GetCompanyResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitValuesResponse;
import com.schematic.api.resources.companies.types.GetOrCreateCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.GetOrCreateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetPlanChangeResponse;
import com.schematic.api.resources.companies.types.GetPlanTraitResponse;
import com.schematic.api.resources.companies.types.GetUserResponse;
import com.schematic.api.resources.companies.types.ListCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.ListCompaniesResponse;
import com.schematic.api.resources.companies.types.ListCompanyMembershipsResponse;
import com.schematic.api.resources.companies.types.ListEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListPlanChangesResponse;
import com.schematic.api.resources.companies.types.ListPlanTraitsResponse;
import com.schematic.api.resources.companies.types.ListUsersResponse;
import com.schematic.api.resources.companies.types.LookupCompanyResponse;
import com.schematic.api.resources.companies.types.LookupUserResponse;
import com.schematic.api.resources.companies.types.UpdateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitsBulkResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyTraitResponse;
import com.schematic.api.resources.companies.types.UpsertUserResponse;
import com.schematic.api.resources.companies.types.UpsertUserTraitResponse;
import com.schematic.api.types.KeysRequestBody;
import com.schematic.api.types.UpsertCompanyRequestBody;
import com.schematic.api.types.UpsertTraitRequestBody;
import com.schematic.api.types.UpsertUserRequestBody;
import java.util.concurrent.CompletableFuture;

public class AsyncCompaniesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCompaniesClient rawClient;

    public AsyncCompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCompaniesClient(clientOptions);
    }

    public AsyncRawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListCompaniesResponse> listCompanies() {
        return this.rawClient.listCompanies().thenApply(response -> (ListCompaniesResponse)response.body());
    }

    public CompletableFuture<ListCompaniesResponse> listCompanies(ListCompaniesRequest request) {
        return this.rawClient.listCompanies(request).thenApply(response -> (ListCompaniesResponse)response.body());
    }

    public CompletableFuture<ListCompaniesResponse> listCompanies(ListCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanies(request, requestOptions).thenApply(response -> (ListCompaniesResponse)response.body());
    }

    public CompletableFuture<UpsertCompanyResponse> upsertCompany(UpsertCompanyRequestBody request) {
        return this.rawClient.upsertCompany(request).thenApply(response -> (UpsertCompanyResponse)response.body());
    }

    public CompletableFuture<UpsertCompanyResponse> upsertCompany(UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCompany(request, requestOptions).thenApply(response -> (UpsertCompanyResponse)response.body());
    }

    public CompletableFuture<GetCompanyResponse> getCompany(String companyId) {
        return this.rawClient.getCompany(companyId).thenApply(response -> (GetCompanyResponse)response.body());
    }

    public CompletableFuture<GetCompanyResponse> getCompany(String companyId, RequestOptions requestOptions) {
        return this.rawClient.getCompany(companyId, requestOptions).thenApply(response -> (GetCompanyResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyResponse> deleteCompany(String companyId) {
        return this.rawClient.deleteCompany(companyId).thenApply(response -> (DeleteCompanyResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyResponse> deleteCompany(String companyId, RequestOptions requestOptions) {
        return this.rawClient.deleteCompany(companyId, requestOptions).thenApply(response -> (DeleteCompanyResponse)response.body());
    }

    public CompletableFuture<CountCompaniesResponse> countCompanies() {
        return this.rawClient.countCompanies().thenApply(response -> (CountCompaniesResponse)response.body());
    }

    public CompletableFuture<CountCompaniesResponse> countCompanies(CountCompaniesRequest request) {
        return this.rawClient.countCompanies(request).thenApply(response -> (CountCompaniesResponse)response.body());
    }

    public CompletableFuture<CountCompaniesResponse> countCompanies(CountCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCompanies(request, requestOptions).thenApply(response -> (CountCompaniesResponse)response.body());
    }

    public CompletableFuture<CountCompaniesForAdvancedFilterResponse> countCompaniesForAdvancedFilter() {
        return this.rawClient.countCompaniesForAdvancedFilter().thenApply(response -> (CountCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<CountCompaniesForAdvancedFilterResponse> countCompaniesForAdvancedFilter(CountCompaniesForAdvancedFilterRequest request) {
        return this.rawClient.countCompaniesForAdvancedFilter(request).thenApply(response -> (CountCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<CountCompaniesForAdvancedFilterResponse> countCompaniesForAdvancedFilter(CountCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCompaniesForAdvancedFilter(request, requestOptions).thenApply(response -> (CountCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<CreateCompanyResponse> createCompany(UpsertCompanyRequestBody request) {
        return this.rawClient.createCompany(request).thenApply(response -> (CreateCompanyResponse)response.body());
    }

    public CompletableFuture<CreateCompanyResponse> createCompany(UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createCompany(request, requestOptions).thenApply(response -> (CreateCompanyResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyByKeysResponse> deleteCompanyByKeys(KeysRequestBody request) {
        return this.rawClient.deleteCompanyByKeys(request).thenApply(response -> (DeleteCompanyByKeysResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyByKeysResponse> deleteCompanyByKeys(KeysRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.deleteCompanyByKeys(request, requestOptions).thenApply(response -> (DeleteCompanyByKeysResponse)response.body());
    }

    public CompletableFuture<ListCompaniesForAdvancedFilterResponse> listCompaniesForAdvancedFilter() {
        return this.rawClient.listCompaniesForAdvancedFilter().thenApply(response -> (ListCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<ListCompaniesForAdvancedFilterResponse> listCompaniesForAdvancedFilter(ListCompaniesForAdvancedFilterRequest request) {
        return this.rawClient.listCompaniesForAdvancedFilter(request).thenApply(response -> (ListCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<ListCompaniesForAdvancedFilterResponse> listCompaniesForAdvancedFilter(ListCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompaniesForAdvancedFilter(request, requestOptions).thenApply(response -> (ListCompaniesForAdvancedFilterResponse)response.body());
    }

    public CompletableFuture<LookupCompanyResponse> lookupCompany(LookupCompanyRequest request) {
        return this.rawClient.lookupCompany(request).thenApply(response -> (LookupCompanyResponse)response.body());
    }

    public CompletableFuture<LookupCompanyResponse> lookupCompany(LookupCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.lookupCompany(request, requestOptions).thenApply(response -> (LookupCompanyResponse)response.body());
    }

    public CompletableFuture<GetActiveDealsResponse> getActiveDeals(GetActiveDealsRequest request) {
        return this.rawClient.getActiveDeals(request).thenApply(response -> (GetActiveDealsResponse)response.body());
    }

    public CompletableFuture<GetActiveDealsResponse> getActiveDeals(GetActiveDealsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getActiveDeals(request, requestOptions).thenApply(response -> (GetActiveDealsResponse)response.body());
    }

    public CompletableFuture<ListCompanyMembershipsResponse> listCompanyMemberships() {
        return this.rawClient.listCompanyMemberships().thenApply(response -> (ListCompanyMembershipsResponse)response.body());
    }

    public CompletableFuture<ListCompanyMembershipsResponse> listCompanyMemberships(ListCompanyMembershipsRequest request) {
        return this.rawClient.listCompanyMemberships(request).thenApply(response -> (ListCompanyMembershipsResponse)response.body());
    }

    public CompletableFuture<ListCompanyMembershipsResponse> listCompanyMemberships(ListCompanyMembershipsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyMemberships(request, requestOptions).thenApply(response -> (ListCompanyMembershipsResponse)response.body());
    }

    public CompletableFuture<GetOrCreateCompanyMembershipResponse> getOrCreateCompanyMembership(GetOrCreateCompanyMembershipRequestBody request) {
        return this.rawClient.getOrCreateCompanyMembership(request).thenApply(response -> (GetOrCreateCompanyMembershipResponse)response.body());
    }

    public CompletableFuture<GetOrCreateCompanyMembershipResponse> getOrCreateCompanyMembership(GetOrCreateCompanyMembershipRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.getOrCreateCompanyMembership(request, requestOptions).thenApply(response -> (GetOrCreateCompanyMembershipResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyMembershipResponse> deleteCompanyMembership(String companyMembershipId) {
        return this.rawClient.deleteCompanyMembership(companyMembershipId).thenApply(response -> (DeleteCompanyMembershipResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyMembershipResponse> deleteCompanyMembership(String companyMembershipId, RequestOptions requestOptions) {
        return this.rawClient.deleteCompanyMembership(companyMembershipId, requestOptions).thenApply(response -> (DeleteCompanyMembershipResponse)response.body());
    }

    public CompletableFuture<GetActiveCompanySubscriptionResponse> getActiveCompanySubscription() {
        return this.rawClient.getActiveCompanySubscription().thenApply(response -> (GetActiveCompanySubscriptionResponse)response.body());
    }

    public CompletableFuture<GetActiveCompanySubscriptionResponse> getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request) {
        return this.rawClient.getActiveCompanySubscription(request).thenApply(response -> (GetActiveCompanySubscriptionResponse)response.body());
    }

    public CompletableFuture<GetActiveCompanySubscriptionResponse> getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.getActiveCompanySubscription(request, requestOptions).thenApply(response -> (GetActiveCompanySubscriptionResponse)response.body());
    }

    public CompletableFuture<UpsertCompanyTraitResponse> upsertCompanyTrait(UpsertTraitRequestBody request) {
        return this.rawClient.upsertCompanyTrait(request).thenApply(response -> (UpsertCompanyTraitResponse)response.body());
    }

    public CompletableFuture<UpsertCompanyTraitResponse> upsertCompanyTrait(UpsertTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCompanyTrait(request, requestOptions).thenApply(response -> (UpsertCompanyTraitResponse)response.body());
    }

    public CompletableFuture<ListEntityKeyDefinitionsResponse> listEntityKeyDefinitions() {
        return this.rawClient.listEntityKeyDefinitions().thenApply(response -> (ListEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<ListEntityKeyDefinitionsResponse> listEntityKeyDefinitions(ListEntityKeyDefinitionsRequest request) {
        return this.rawClient.listEntityKeyDefinitions(request).thenApply(response -> (ListEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<ListEntityKeyDefinitionsResponse> listEntityKeyDefinitions(ListEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEntityKeyDefinitions(request, requestOptions).thenApply(response -> (ListEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<CountEntityKeyDefinitionsResponse> countEntityKeyDefinitions() {
        return this.rawClient.countEntityKeyDefinitions().thenApply(response -> (CountEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<CountEntityKeyDefinitionsResponse> countEntityKeyDefinitions(CountEntityKeyDefinitionsRequest request) {
        return this.rawClient.countEntityKeyDefinitions(request).thenApply(response -> (CountEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<CountEntityKeyDefinitionsResponse> countEntityKeyDefinitions(CountEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countEntityKeyDefinitions(request, requestOptions).thenApply(response -> (CountEntityKeyDefinitionsResponse)response.body());
    }

    public CompletableFuture<ListEntityTraitDefinitionsResponse> listEntityTraitDefinitions() {
        return this.rawClient.listEntityTraitDefinitions().thenApply(response -> (ListEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<ListEntityTraitDefinitionsResponse> listEntityTraitDefinitions(ListEntityTraitDefinitionsRequest request) {
        return this.rawClient.listEntityTraitDefinitions(request).thenApply(response -> (ListEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<ListEntityTraitDefinitionsResponse> listEntityTraitDefinitions(ListEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEntityTraitDefinitions(request, requestOptions).thenApply(response -> (ListEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<GetOrCreateEntityTraitDefinitionResponse> getOrCreateEntityTraitDefinition(CreateEntityTraitDefinitionRequestBody request) {
        return this.rawClient.getOrCreateEntityTraitDefinition(request).thenApply(response -> (GetOrCreateEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<GetOrCreateEntityTraitDefinitionResponse> getOrCreateEntityTraitDefinition(CreateEntityTraitDefinitionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.getOrCreateEntityTraitDefinition(request, requestOptions).thenApply(response -> (GetOrCreateEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<GetEntityTraitDefinitionResponse> getEntityTraitDefinition(String entityTraitDefinitionId) {
        return this.rawClient.getEntityTraitDefinition(entityTraitDefinitionId).thenApply(response -> (GetEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<GetEntityTraitDefinitionResponse> getEntityTraitDefinition(String entityTraitDefinitionId, RequestOptions requestOptions) {
        return this.rawClient.getEntityTraitDefinition(entityTraitDefinitionId, requestOptions).thenApply(response -> (GetEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateEntityTraitDefinitionResponse> updateEntityTraitDefinition(String entityTraitDefinitionId, UpdateEntityTraitDefinitionRequestBody request) {
        return this.rawClient.updateEntityTraitDefinition(entityTraitDefinitionId, request).thenApply(response -> (UpdateEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateEntityTraitDefinitionResponse> updateEntityTraitDefinition(String entityTraitDefinitionId, UpdateEntityTraitDefinitionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateEntityTraitDefinition(entityTraitDefinitionId, request, requestOptions).thenApply(response -> (UpdateEntityTraitDefinitionResponse)response.body());
    }

    public CompletableFuture<CountEntityTraitDefinitionsResponse> countEntityTraitDefinitions() {
        return this.rawClient.countEntityTraitDefinitions().thenApply(response -> (CountEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<CountEntityTraitDefinitionsResponse> countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request) {
        return this.rawClient.countEntityTraitDefinitions(request).thenApply(response -> (CountEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<CountEntityTraitDefinitionsResponse> countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countEntityTraitDefinitions(request, requestOptions).thenApply(response -> (CountEntityTraitDefinitionsResponse)response.body());
    }

    public CompletableFuture<GetEntityTraitValuesResponse> getEntityTraitValues(GetEntityTraitValuesRequest request) {
        return this.rawClient.getEntityTraitValues(request).thenApply(response -> (GetEntityTraitValuesResponse)response.body());
    }

    public CompletableFuture<GetEntityTraitValuesResponse> getEntityTraitValues(GetEntityTraitValuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEntityTraitValues(request, requestOptions).thenApply(response -> (GetEntityTraitValuesResponse)response.body());
    }

    public CompletableFuture<ListPlanChangesResponse> listPlanChanges() {
        return this.rawClient.listPlanChanges().thenApply(response -> (ListPlanChangesResponse)response.body());
    }

    public CompletableFuture<ListPlanChangesResponse> listPlanChanges(ListPlanChangesRequest request) {
        return this.rawClient.listPlanChanges(request).thenApply(response -> (ListPlanChangesResponse)response.body());
    }

    public CompletableFuture<ListPlanChangesResponse> listPlanChanges(ListPlanChangesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanChanges(request, requestOptions).thenApply(response -> (ListPlanChangesResponse)response.body());
    }

    public CompletableFuture<GetPlanChangeResponse> getPlanChange(String planChangeId) {
        return this.rawClient.getPlanChange(planChangeId).thenApply(response -> (GetPlanChangeResponse)response.body());
    }

    public CompletableFuture<GetPlanChangeResponse> getPlanChange(String planChangeId, RequestOptions requestOptions) {
        return this.rawClient.getPlanChange(planChangeId, requestOptions).thenApply(response -> (GetPlanChangeResponse)response.body());
    }

    public CompletableFuture<ListPlanTraitsResponse> listPlanTraits() {
        return this.rawClient.listPlanTraits().thenApply(response -> (ListPlanTraitsResponse)response.body());
    }

    public CompletableFuture<ListPlanTraitsResponse> listPlanTraits(ListPlanTraitsRequest request) {
        return this.rawClient.listPlanTraits(request).thenApply(response -> (ListPlanTraitsResponse)response.body());
    }

    public CompletableFuture<ListPlanTraitsResponse> listPlanTraits(ListPlanTraitsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanTraits(request, requestOptions).thenApply(response -> (ListPlanTraitsResponse)response.body());
    }

    public CompletableFuture<CreatePlanTraitResponse> createPlanTrait(CreatePlanTraitRequestBody request) {
        return this.rawClient.createPlanTrait(request).thenApply(response -> (CreatePlanTraitResponse)response.body());
    }

    public CompletableFuture<CreatePlanTraitResponse> createPlanTrait(CreatePlanTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlanTrait(request, requestOptions).thenApply(response -> (CreatePlanTraitResponse)response.body());
    }

    public CompletableFuture<GetPlanTraitResponse> getPlanTrait(String planTraitId) {
        return this.rawClient.getPlanTrait(planTraitId).thenApply(response -> (GetPlanTraitResponse)response.body());
    }

    public CompletableFuture<GetPlanTraitResponse> getPlanTrait(String planTraitId, RequestOptions requestOptions) {
        return this.rawClient.getPlanTrait(planTraitId, requestOptions).thenApply(response -> (GetPlanTraitResponse)response.body());
    }

    public CompletableFuture<UpdatePlanTraitResponse> updatePlanTrait(String planTraitId, UpdatePlanTraitRequestBody request) {
        return this.rawClient.updatePlanTrait(planTraitId, request).thenApply(response -> (UpdatePlanTraitResponse)response.body());
    }

    public CompletableFuture<UpdatePlanTraitResponse> updatePlanTrait(String planTraitId, UpdatePlanTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanTrait(planTraitId, request, requestOptions).thenApply(response -> (UpdatePlanTraitResponse)response.body());
    }

    public CompletableFuture<DeletePlanTraitResponse> deletePlanTrait(String planTraitId) {
        return this.rawClient.deletePlanTrait(planTraitId).thenApply(response -> (DeletePlanTraitResponse)response.body());
    }

    public CompletableFuture<DeletePlanTraitResponse> deletePlanTrait(String planTraitId, RequestOptions requestOptions) {
        return this.rawClient.deletePlanTrait(planTraitId, requestOptions).thenApply(response -> (DeletePlanTraitResponse)response.body());
    }

    public CompletableFuture<UpdatePlanTraitsBulkResponse> updatePlanTraitsBulk(UpdatePlanTraitBulkRequestBody request) {
        return this.rawClient.updatePlanTraitsBulk(request).thenApply(response -> (UpdatePlanTraitsBulkResponse)response.body());
    }

    public CompletableFuture<UpdatePlanTraitsBulkResponse> updatePlanTraitsBulk(UpdatePlanTraitBulkRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanTraitsBulk(request, requestOptions).thenApply(response -> (UpdatePlanTraitsBulkResponse)response.body());
    }

    public CompletableFuture<CountPlanTraitsResponse> countPlanTraits() {
        return this.rawClient.countPlanTraits().thenApply(response -> (CountPlanTraitsResponse)response.body());
    }

    public CompletableFuture<CountPlanTraitsResponse> countPlanTraits(CountPlanTraitsRequest request) {
        return this.rawClient.countPlanTraits(request).thenApply(response -> (CountPlanTraitsResponse)response.body());
    }

    public CompletableFuture<CountPlanTraitsResponse> countPlanTraits(CountPlanTraitsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countPlanTraits(request, requestOptions).thenApply(response -> (CountPlanTraitsResponse)response.body());
    }

    public CompletableFuture<UpsertUserTraitResponse> upsertUserTrait(UpsertTraitRequestBody request) {
        return this.rawClient.upsertUserTrait(request).thenApply(response -> (UpsertUserTraitResponse)response.body());
    }

    public CompletableFuture<UpsertUserTraitResponse> upsertUserTrait(UpsertTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertUserTrait(request, requestOptions).thenApply(response -> (UpsertUserTraitResponse)response.body());
    }

    public CompletableFuture<ListUsersResponse> listUsers() {
        return this.rawClient.listUsers().thenApply(response -> (ListUsersResponse)response.body());
    }

    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest request) {
        return this.rawClient.listUsers(request).thenApply(response -> (ListUsersResponse)response.body());
    }

    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.listUsers(request, requestOptions).thenApply(response -> (ListUsersResponse)response.body());
    }

    public CompletableFuture<UpsertUserResponse> upsertUser(UpsertUserRequestBody request) {
        return this.rawClient.upsertUser(request).thenApply(response -> (UpsertUserResponse)response.body());
    }

    public CompletableFuture<UpsertUserResponse> upsertUser(UpsertUserRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertUser(request, requestOptions).thenApply(response -> (UpsertUserResponse)response.body());
    }

    public CompletableFuture<GetUserResponse> getUser(String userId) {
        return this.rawClient.getUser(userId).thenApply(response -> (GetUserResponse)response.body());
    }

    public CompletableFuture<GetUserResponse> getUser(String userId, RequestOptions requestOptions) {
        return this.rawClient.getUser(userId, requestOptions).thenApply(response -> (GetUserResponse)response.body());
    }

    public CompletableFuture<DeleteUserResponse> deleteUser(String userId) {
        return this.rawClient.deleteUser(userId).thenApply(response -> (DeleteUserResponse)response.body());
    }

    public CompletableFuture<DeleteUserResponse> deleteUser(String userId, RequestOptions requestOptions) {
        return this.rawClient.deleteUser(userId, requestOptions).thenApply(response -> (DeleteUserResponse)response.body());
    }

    public CompletableFuture<CountUsersResponse> countUsers() {
        return this.rawClient.countUsers().thenApply(response -> (CountUsersResponse)response.body());
    }

    public CompletableFuture<CountUsersResponse> countUsers(CountUsersRequest request) {
        return this.rawClient.countUsers(request).thenApply(response -> (CountUsersResponse)response.body());
    }

    public CompletableFuture<CountUsersResponse> countUsers(CountUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.countUsers(request, requestOptions).thenApply(response -> (CountUsersResponse)response.body());
    }

    public CompletableFuture<CreateUserResponse> createUser(UpsertUserRequestBody request) {
        return this.rawClient.createUser(request).thenApply(response -> (CreateUserResponse)response.body());
    }

    public CompletableFuture<CreateUserResponse> createUser(UpsertUserRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createUser(request, requestOptions).thenApply(response -> (CreateUserResponse)response.body());
    }

    public CompletableFuture<DeleteUserByKeysResponse> deleteUserByKeys(KeysRequestBody request) {
        return this.rawClient.deleteUserByKeys(request).thenApply(response -> (DeleteUserByKeysResponse)response.body());
    }

    public CompletableFuture<DeleteUserByKeysResponse> deleteUserByKeys(KeysRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.deleteUserByKeys(request, requestOptions).thenApply(response -> (DeleteUserByKeysResponse)response.body());
    }

    public CompletableFuture<LookupUserResponse> lookupUser(LookupUserRequest request) {
        return this.rawClient.lookupUser(request).thenApply(response -> (LookupUserResponse)response.body());
    }

    public CompletableFuture<LookupUserResponse> lookupUser(LookupUserRequest request, RequestOptions requestOptions) {
        return this.rawClient.lookupUser(request, requestOptions).thenApply(response -> (LookupUserResponse)response.body());
    }
}

