/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.companies.RawCompaniesClient;
import com.schematic.api.resources.companies.requests.CountCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.CountCompaniesRequest;
import com.schematic.api.resources.companies.requests.CountEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.CountPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.CountUsersRequest;
import com.schematic.api.resources.companies.requests.CreateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.CreatePlanTraitRequestBody;
import com.schematic.api.resources.companies.requests.GetActiveCompanySubscriptionRequest;
import com.schematic.api.resources.companies.requests.GetActiveDealsRequest;
import com.schematic.api.resources.companies.requests.GetEntityTraitValuesRequest;
import com.schematic.api.resources.companies.requests.GetOrCreateCompanyMembershipRequestBody;
import com.schematic.api.resources.companies.requests.ListCompaniesForAdvancedFilterRequest;
import com.schematic.api.resources.companies.requests.ListCompaniesRequest;
import com.schematic.api.resources.companies.requests.ListCompanyMembershipsRequest;
import com.schematic.api.resources.companies.requests.ListEntityKeyDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListEntityTraitDefinitionsRequest;
import com.schematic.api.resources.companies.requests.ListPlanChangesRequest;
import com.schematic.api.resources.companies.requests.ListPlanTraitsRequest;
import com.schematic.api.resources.companies.requests.ListUsersRequest;
import com.schematic.api.resources.companies.requests.LookupCompanyRequest;
import com.schematic.api.resources.companies.requests.LookupUserRequest;
import com.schematic.api.resources.companies.requests.UpdateEntityTraitDefinitionRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitBulkRequestBody;
import com.schematic.api.resources.companies.requests.UpdatePlanTraitRequestBody;
import com.schematic.api.resources.companies.types.CountCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.CountCompaniesResponse;
import com.schematic.api.resources.companies.types.CountEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.CountPlanTraitsResponse;
import com.schematic.api.resources.companies.types.CountUsersResponse;
import com.schematic.api.resources.companies.types.CreateCompanyResponse;
import com.schematic.api.resources.companies.types.CreatePlanTraitResponse;
import com.schematic.api.resources.companies.types.CreateUserResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.DeleteCompanyResponse;
import com.schematic.api.resources.companies.types.DeletePlanTraitResponse;
import com.schematic.api.resources.companies.types.DeleteUserByKeysResponse;
import com.schematic.api.resources.companies.types.DeleteUserResponse;
import com.schematic.api.resources.companies.types.GetActiveCompanySubscriptionResponse;
import com.schematic.api.resources.companies.types.GetActiveDealsResponse;
import com.schematic.api.resources.companies.types.GetCompanyResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetEntityTraitValuesResponse;
import com.schematic.api.resources.companies.types.GetOrCreateCompanyMembershipResponse;
import com.schematic.api.resources.companies.types.GetOrCreateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.GetPlanChangeResponse;
import com.schematic.api.resources.companies.types.GetPlanTraitResponse;
import com.schematic.api.resources.companies.types.GetUserResponse;
import com.schematic.api.resources.companies.types.ListCompaniesForAdvancedFilterResponse;
import com.schematic.api.resources.companies.types.ListCompaniesResponse;
import com.schematic.api.resources.companies.types.ListCompanyMembershipsResponse;
import com.schematic.api.resources.companies.types.ListEntityKeyDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListEntityTraitDefinitionsResponse;
import com.schematic.api.resources.companies.types.ListPlanChangesResponse;
import com.schematic.api.resources.companies.types.ListPlanTraitsResponse;
import com.schematic.api.resources.companies.types.ListUsersResponse;
import com.schematic.api.resources.companies.types.LookupCompanyResponse;
import com.schematic.api.resources.companies.types.LookupUserResponse;
import com.schematic.api.resources.companies.types.UpdateEntityTraitDefinitionResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitResponse;
import com.schematic.api.resources.companies.types.UpdatePlanTraitsBulkResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyResponse;
import com.schematic.api.resources.companies.types.UpsertCompanyTraitResponse;
import com.schematic.api.resources.companies.types.UpsertUserResponse;
import com.schematic.api.resources.companies.types.UpsertUserTraitResponse;
import com.schematic.api.types.KeysRequestBody;
import com.schematic.api.types.UpsertCompanyRequestBody;
import com.schematic.api.types.UpsertTraitRequestBody;
import com.schematic.api.types.UpsertUserRequestBody;

public class CompaniesClient {
    protected final ClientOptions clientOptions;
    private final RawCompaniesClient rawClient;

    public CompaniesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCompaniesClient(clientOptions);
    }

    public RawCompaniesClient withRawResponse() {
        return this.rawClient;
    }

    public ListCompaniesResponse listCompanies() {
        return this.rawClient.listCompanies().body();
    }

    public ListCompaniesResponse listCompanies(ListCompaniesRequest request) {
        return this.rawClient.listCompanies(request).body();
    }

    public ListCompaniesResponse listCompanies(ListCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanies(request, requestOptions).body();
    }

    public UpsertCompanyResponse upsertCompany(UpsertCompanyRequestBody request) {
        return this.rawClient.upsertCompany(request).body();
    }

    public UpsertCompanyResponse upsertCompany(UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCompany(request, requestOptions).body();
    }

    public GetCompanyResponse getCompany(String companyId) {
        return this.rawClient.getCompany(companyId).body();
    }

    public GetCompanyResponse getCompany(String companyId, RequestOptions requestOptions) {
        return this.rawClient.getCompany(companyId, requestOptions).body();
    }

    public DeleteCompanyResponse deleteCompany(String companyId) {
        return this.rawClient.deleteCompany(companyId).body();
    }

    public DeleteCompanyResponse deleteCompany(String companyId, RequestOptions requestOptions) {
        return this.rawClient.deleteCompany(companyId, requestOptions).body();
    }

    public CountCompaniesResponse countCompanies() {
        return this.rawClient.countCompanies().body();
    }

    public CountCompaniesResponse countCompanies(CountCompaniesRequest request) {
        return this.rawClient.countCompanies(request).body();
    }

    public CountCompaniesResponse countCompanies(CountCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCompanies(request, requestOptions).body();
    }

    public CountCompaniesForAdvancedFilterResponse countCompaniesForAdvancedFilter() {
        return this.rawClient.countCompaniesForAdvancedFilter().body();
    }

    public CountCompaniesForAdvancedFilterResponse countCompaniesForAdvancedFilter(CountCompaniesForAdvancedFilterRequest request) {
        return this.rawClient.countCompaniesForAdvancedFilter(request).body();
    }

    public CountCompaniesForAdvancedFilterResponse countCompaniesForAdvancedFilter(CountCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCompaniesForAdvancedFilter(request, requestOptions).body();
    }

    public CreateCompanyResponse createCompany(UpsertCompanyRequestBody request) {
        return this.rawClient.createCompany(request).body();
    }

    public CreateCompanyResponse createCompany(UpsertCompanyRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createCompany(request, requestOptions).body();
    }

    public DeleteCompanyByKeysResponse deleteCompanyByKeys(KeysRequestBody request) {
        return this.rawClient.deleteCompanyByKeys(request).body();
    }

    public DeleteCompanyByKeysResponse deleteCompanyByKeys(KeysRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.deleteCompanyByKeys(request, requestOptions).body();
    }

    public ListCompaniesForAdvancedFilterResponse listCompaniesForAdvancedFilter() {
        return this.rawClient.listCompaniesForAdvancedFilter().body();
    }

    public ListCompaniesForAdvancedFilterResponse listCompaniesForAdvancedFilter(ListCompaniesForAdvancedFilterRequest request) {
        return this.rawClient.listCompaniesForAdvancedFilter(request).body();
    }

    public ListCompaniesForAdvancedFilterResponse listCompaniesForAdvancedFilter(ListCompaniesForAdvancedFilterRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompaniesForAdvancedFilter(request, requestOptions).body();
    }

    public LookupCompanyResponse lookupCompany(LookupCompanyRequest request) {
        return this.rawClient.lookupCompany(request).body();
    }

    public LookupCompanyResponse lookupCompany(LookupCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.lookupCompany(request, requestOptions).body();
    }

    public GetActiveDealsResponse getActiveDeals(GetActiveDealsRequest request) {
        return this.rawClient.getActiveDeals(request).body();
    }

    public GetActiveDealsResponse getActiveDeals(GetActiveDealsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getActiveDeals(request, requestOptions).body();
    }

    public ListCompanyMembershipsResponse listCompanyMemberships() {
        return this.rawClient.listCompanyMemberships().body();
    }

    public ListCompanyMembershipsResponse listCompanyMemberships(ListCompanyMembershipsRequest request) {
        return this.rawClient.listCompanyMemberships(request).body();
    }

    public ListCompanyMembershipsResponse listCompanyMemberships(ListCompanyMembershipsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyMemberships(request, requestOptions).body();
    }

    public GetOrCreateCompanyMembershipResponse getOrCreateCompanyMembership(GetOrCreateCompanyMembershipRequestBody request) {
        return this.rawClient.getOrCreateCompanyMembership(request).body();
    }

    public GetOrCreateCompanyMembershipResponse getOrCreateCompanyMembership(GetOrCreateCompanyMembershipRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.getOrCreateCompanyMembership(request, requestOptions).body();
    }

    public DeleteCompanyMembershipResponse deleteCompanyMembership(String companyMembershipId) {
        return this.rawClient.deleteCompanyMembership(companyMembershipId).body();
    }

    public DeleteCompanyMembershipResponse deleteCompanyMembership(String companyMembershipId, RequestOptions requestOptions) {
        return this.rawClient.deleteCompanyMembership(companyMembershipId, requestOptions).body();
    }

    public GetActiveCompanySubscriptionResponse getActiveCompanySubscription() {
        return this.rawClient.getActiveCompanySubscription().body();
    }

    public GetActiveCompanySubscriptionResponse getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request) {
        return this.rawClient.getActiveCompanySubscription(request).body();
    }

    public GetActiveCompanySubscriptionResponse getActiveCompanySubscription(GetActiveCompanySubscriptionRequest request, RequestOptions requestOptions) {
        return this.rawClient.getActiveCompanySubscription(request, requestOptions).body();
    }

    public UpsertCompanyTraitResponse upsertCompanyTrait(UpsertTraitRequestBody request) {
        return this.rawClient.upsertCompanyTrait(request).body();
    }

    public UpsertCompanyTraitResponse upsertCompanyTrait(UpsertTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCompanyTrait(request, requestOptions).body();
    }

    public ListEntityKeyDefinitionsResponse listEntityKeyDefinitions() {
        return this.rawClient.listEntityKeyDefinitions().body();
    }

    public ListEntityKeyDefinitionsResponse listEntityKeyDefinitions(ListEntityKeyDefinitionsRequest request) {
        return this.rawClient.listEntityKeyDefinitions(request).body();
    }

    public ListEntityKeyDefinitionsResponse listEntityKeyDefinitions(ListEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEntityKeyDefinitions(request, requestOptions).body();
    }

    public CountEntityKeyDefinitionsResponse countEntityKeyDefinitions() {
        return this.rawClient.countEntityKeyDefinitions().body();
    }

    public CountEntityKeyDefinitionsResponse countEntityKeyDefinitions(CountEntityKeyDefinitionsRequest request) {
        return this.rawClient.countEntityKeyDefinitions(request).body();
    }

    public CountEntityKeyDefinitionsResponse countEntityKeyDefinitions(CountEntityKeyDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countEntityKeyDefinitions(request, requestOptions).body();
    }

    public ListEntityTraitDefinitionsResponse listEntityTraitDefinitions() {
        return this.rawClient.listEntityTraitDefinitions().body();
    }

    public ListEntityTraitDefinitionsResponse listEntityTraitDefinitions(ListEntityTraitDefinitionsRequest request) {
        return this.rawClient.listEntityTraitDefinitions(request).body();
    }

    public ListEntityTraitDefinitionsResponse listEntityTraitDefinitions(ListEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEntityTraitDefinitions(request, requestOptions).body();
    }

    public GetOrCreateEntityTraitDefinitionResponse getOrCreateEntityTraitDefinition(CreateEntityTraitDefinitionRequestBody request) {
        return this.rawClient.getOrCreateEntityTraitDefinition(request).body();
    }

    public GetOrCreateEntityTraitDefinitionResponse getOrCreateEntityTraitDefinition(CreateEntityTraitDefinitionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.getOrCreateEntityTraitDefinition(request, requestOptions).body();
    }

    public GetEntityTraitDefinitionResponse getEntityTraitDefinition(String entityTraitDefinitionId) {
        return this.rawClient.getEntityTraitDefinition(entityTraitDefinitionId).body();
    }

    public GetEntityTraitDefinitionResponse getEntityTraitDefinition(String entityTraitDefinitionId, RequestOptions requestOptions) {
        return this.rawClient.getEntityTraitDefinition(entityTraitDefinitionId, requestOptions).body();
    }

    public UpdateEntityTraitDefinitionResponse updateEntityTraitDefinition(String entityTraitDefinitionId, UpdateEntityTraitDefinitionRequestBody request) {
        return this.rawClient.updateEntityTraitDefinition(entityTraitDefinitionId, request).body();
    }

    public UpdateEntityTraitDefinitionResponse updateEntityTraitDefinition(String entityTraitDefinitionId, UpdateEntityTraitDefinitionRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateEntityTraitDefinition(entityTraitDefinitionId, request, requestOptions).body();
    }

    public CountEntityTraitDefinitionsResponse countEntityTraitDefinitions() {
        return this.rawClient.countEntityTraitDefinitions().body();
    }

    public CountEntityTraitDefinitionsResponse countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request) {
        return this.rawClient.countEntityTraitDefinitions(request).body();
    }

    public CountEntityTraitDefinitionsResponse countEntityTraitDefinitions(CountEntityTraitDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countEntityTraitDefinitions(request, requestOptions).body();
    }

    public GetEntityTraitValuesResponse getEntityTraitValues(GetEntityTraitValuesRequest request) {
        return this.rawClient.getEntityTraitValues(request).body();
    }

    public GetEntityTraitValuesResponse getEntityTraitValues(GetEntityTraitValuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEntityTraitValues(request, requestOptions).body();
    }

    public ListPlanChangesResponse listPlanChanges() {
        return this.rawClient.listPlanChanges().body();
    }

    public ListPlanChangesResponse listPlanChanges(ListPlanChangesRequest request) {
        return this.rawClient.listPlanChanges(request).body();
    }

    public ListPlanChangesResponse listPlanChanges(ListPlanChangesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanChanges(request, requestOptions).body();
    }

    public GetPlanChangeResponse getPlanChange(String planChangeId) {
        return this.rawClient.getPlanChange(planChangeId).body();
    }

    public GetPlanChangeResponse getPlanChange(String planChangeId, RequestOptions requestOptions) {
        return this.rawClient.getPlanChange(planChangeId, requestOptions).body();
    }

    public ListPlanTraitsResponse listPlanTraits() {
        return this.rawClient.listPlanTraits().body();
    }

    public ListPlanTraitsResponse listPlanTraits(ListPlanTraitsRequest request) {
        return this.rawClient.listPlanTraits(request).body();
    }

    public ListPlanTraitsResponse listPlanTraits(ListPlanTraitsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanTraits(request, requestOptions).body();
    }

    public CreatePlanTraitResponse createPlanTrait(CreatePlanTraitRequestBody request) {
        return this.rawClient.createPlanTrait(request).body();
    }

    public CreatePlanTraitResponse createPlanTrait(CreatePlanTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlanTrait(request, requestOptions).body();
    }

    public GetPlanTraitResponse getPlanTrait(String planTraitId) {
        return this.rawClient.getPlanTrait(planTraitId).body();
    }

    public GetPlanTraitResponse getPlanTrait(String planTraitId, RequestOptions requestOptions) {
        return this.rawClient.getPlanTrait(planTraitId, requestOptions).body();
    }

    public UpdatePlanTraitResponse updatePlanTrait(String planTraitId, UpdatePlanTraitRequestBody request) {
        return this.rawClient.updatePlanTrait(planTraitId, request).body();
    }

    public UpdatePlanTraitResponse updatePlanTrait(String planTraitId, UpdatePlanTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanTrait(planTraitId, request, requestOptions).body();
    }

    public DeletePlanTraitResponse deletePlanTrait(String planTraitId) {
        return this.rawClient.deletePlanTrait(planTraitId).body();
    }

    public DeletePlanTraitResponse deletePlanTrait(String planTraitId, RequestOptions requestOptions) {
        return this.rawClient.deletePlanTrait(planTraitId, requestOptions).body();
    }

    public UpdatePlanTraitsBulkResponse updatePlanTraitsBulk(UpdatePlanTraitBulkRequestBody request) {
        return this.rawClient.updatePlanTraitsBulk(request).body();
    }

    public UpdatePlanTraitsBulkResponse updatePlanTraitsBulk(UpdatePlanTraitBulkRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanTraitsBulk(request, requestOptions).body();
    }

    public CountPlanTraitsResponse countPlanTraits() {
        return this.rawClient.countPlanTraits().body();
    }

    public CountPlanTraitsResponse countPlanTraits(CountPlanTraitsRequest request) {
        return this.rawClient.countPlanTraits(request).body();
    }

    public CountPlanTraitsResponse countPlanTraits(CountPlanTraitsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countPlanTraits(request, requestOptions).body();
    }

    public UpsertUserTraitResponse upsertUserTrait(UpsertTraitRequestBody request) {
        return this.rawClient.upsertUserTrait(request).body();
    }

    public UpsertUserTraitResponse upsertUserTrait(UpsertTraitRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertUserTrait(request, requestOptions).body();
    }

    public ListUsersResponse listUsers() {
        return this.rawClient.listUsers().body();
    }

    public ListUsersResponse listUsers(ListUsersRequest request) {
        return this.rawClient.listUsers(request).body();
    }

    public ListUsersResponse listUsers(ListUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.listUsers(request, requestOptions).body();
    }

    public UpsertUserResponse upsertUser(UpsertUserRequestBody request) {
        return this.rawClient.upsertUser(request).body();
    }

    public UpsertUserResponse upsertUser(UpsertUserRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertUser(request, requestOptions).body();
    }

    public GetUserResponse getUser(String userId) {
        return this.rawClient.getUser(userId).body();
    }

    public GetUserResponse getUser(String userId, RequestOptions requestOptions) {
        return this.rawClient.getUser(userId, requestOptions).body();
    }

    public DeleteUserResponse deleteUser(String userId) {
        return this.rawClient.deleteUser(userId).body();
    }

    public DeleteUserResponse deleteUser(String userId, RequestOptions requestOptions) {
        return this.rawClient.deleteUser(userId, requestOptions).body();
    }

    public CountUsersResponse countUsers() {
        return this.rawClient.countUsers().body();
    }

    public CountUsersResponse countUsers(CountUsersRequest request) {
        return this.rawClient.countUsers(request).body();
    }

    public CountUsersResponse countUsers(CountUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.countUsers(request, requestOptions).body();
    }

    public CreateUserResponse createUser(UpsertUserRequestBody request) {
        return this.rawClient.createUser(request).body();
    }

    public CreateUserResponse createUser(UpsertUserRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createUser(request, requestOptions).body();
    }

    public DeleteUserByKeysResponse deleteUserByKeys(KeysRequestBody request) {
        return this.rawClient.deleteUserByKeys(request).body();
    }

    public DeleteUserByKeysResponse deleteUserByKeys(KeysRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.deleteUserByKeys(request, requestOptions).body();
    }

    public LookupUserResponse lookupUser(LookupUserRequest request) {
        return this.rawClient.lookupUser(request).body();
    }

    public LookupUserResponse lookupUser(LookupUserRequest request, RequestOptions requestOptions) {
        return this.rawClient.lookupUser(request, requestOptions).body();
    }
}

