/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.companies.types.CreateEntityTraitDefinitionRequestBodyEntityType;
import com.schematic.api.resources.companies.types.CreateEntityTraitDefinitionRequestBodyTraitType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateEntityTraitDefinitionRequestBody {
    private final Optional<String> displayName;
    private final CreateEntityTraitDefinitionRequestBodyEntityType entityType;
    private final List<String> hierarchy;
    private final CreateEntityTraitDefinitionRequestBodyTraitType traitType;
    private final Map<String, Object> additionalProperties;

    private CreateEntityTraitDefinitionRequestBody(Optional<String> displayName, CreateEntityTraitDefinitionRequestBodyEntityType entityType, List<String> hierarchy, CreateEntityTraitDefinitionRequestBodyTraitType traitType, Map<String, Object> additionalProperties) {
        this.displayName = displayName;
        this.entityType = entityType;
        this.hierarchy = hierarchy;
        this.traitType = traitType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="entity_type")
    public CreateEntityTraitDefinitionRequestBodyEntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="hierarchy")
    public List<String> getHierarchy() {
        return this.hierarchy;
    }

    @JsonProperty(value="trait_type")
    public CreateEntityTraitDefinitionRequestBodyTraitType getTraitType() {
        return this.traitType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateEntityTraitDefinitionRequestBody && this.equalTo((CreateEntityTraitDefinitionRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEntityTraitDefinitionRequestBody other) {
        return this.displayName.equals(other.displayName) && this.entityType.equals(other.entityType) && this.hierarchy.equals(other.hierarchy) && this.traitType.equals(other.traitType);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.entityType, this.hierarchy, this.traitType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntityTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EntityTypeStage,
    TraitTypeStage,
    _FinalStage {
        private CreateEntityTraitDefinitionRequestBodyEntityType entityType;
        private CreateEntityTraitDefinitionRequestBodyTraitType traitType;
        private List<String> hierarchy = new ArrayList<String>();
        private Optional<String> displayName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateEntityTraitDefinitionRequestBody other) {
            this.displayName(other.getDisplayName());
            this.entityType(other.getEntityType());
            this.hierarchy(other.getHierarchy());
            this.traitType(other.getTraitType());
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public TraitTypeStage entityType(@NotNull CreateEntityTraitDefinitionRequestBodyEntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_type")
        public _FinalStage traitType(@NotNull CreateEntityTraitDefinitionRequestBodyTraitType traitType) {
            this.traitType = Objects.requireNonNull(traitType, "traitType must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllHierarchy(List<String> hierarchy) {
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @Override
        public _FinalStage addHierarchy(String hierarchy) {
            this.hierarchy.add(hierarchy);
            return this;
        }

        @Override
        @JsonSetter(value="hierarchy", nulls=Nulls.SKIP)
        public _FinalStage hierarchy(List<String> hierarchy) {
            this.hierarchy.clear();
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @Override
        public _FinalStage displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        @Override
        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public _FinalStage displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public CreateEntityTraitDefinitionRequestBody build() {
            return new CreateEntityTraitDefinitionRequestBody(this.displayName, this.entityType, this.hierarchy, this.traitType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateEntityTraitDefinitionRequestBody build();

        public _FinalStage displayName(Optional<String> var1);

        public _FinalStage displayName(String var1);

        public _FinalStage hierarchy(List<String> var1);

        public _FinalStage addHierarchy(String var1);

        public _FinalStage addAllHierarchy(List<String> var1);
    }

    public static interface TraitTypeStage {
        public _FinalStage traitType(@NotNull CreateEntityTraitDefinitionRequestBodyTraitType var1);
    }

    public static interface EntityTypeStage {
        public TraitTypeStage entityType(@NotNull CreateEntityTraitDefinitionRequestBodyEntityType var1);

        public Builder from(CreateEntityTraitDefinitionRequestBody var1);
    }
}

