/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPlanChangesRequest {
    private final Optional<List<String>> companyIds;
    private final Optional<List<String>> planIds;
    private final Optional<String> action;
    private final Optional<String> basePlanAction;
    private final Optional<String> companyId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListPlanChangesRequest(Optional<List<String>> companyIds, Optional<List<String>> planIds, Optional<String> action, Optional<String> basePlanAction, Optional<String> companyId, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyIds = companyIds;
        this.planIds = planIds;
        this.action = action;
        this.basePlanAction = basePlanAction;
        this.companyId = companyId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_ids")
    public Optional<List<String>> getCompanyIds() {
        return this.companyIds;
    }

    @JsonProperty(value="plan_ids")
    public Optional<List<String>> getPlanIds() {
        return this.planIds;
    }

    @JsonProperty(value="action")
    public Optional<String> getAction() {
        return this.action;
    }

    @JsonProperty(value="base_plan_action")
    public Optional<String> getBasePlanAction() {
        return this.basePlanAction;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPlanChangesRequest && this.equalTo((ListPlanChangesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPlanChangesRequest other) {
        return this.companyIds.equals(other.companyIds) && this.planIds.equals(other.planIds) && this.action.equals(other.action) && this.basePlanAction.equals(other.basePlanAction) && this.companyId.equals(other.companyId) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyIds, this.planIds, this.action, this.basePlanAction, this.companyId, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> companyIds = Optional.empty();
        private Optional<List<String>> planIds = Optional.empty();
        private Optional<String> action = Optional.empty();
        private Optional<String> basePlanAction = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPlanChangesRequest other) {
            this.companyIds(other.getCompanyIds());
            this.planIds(other.getPlanIds());
            this.action(other.getAction());
            this.basePlanAction(other.getBasePlanAction());
            this.companyId(other.getCompanyId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="company_ids", nulls=Nulls.SKIP)
        public Builder companyIds(Optional<List<String>> companyIds) {
            this.companyIds = companyIds;
            return this;
        }

        public Builder companyIds(List<String> companyIds) {
            this.companyIds = Optional.ofNullable(companyIds);
            return this;
        }

        public Builder companyIds(String companyIds) {
            this.companyIds = Optional.of(Collections.singletonList(companyIds));
            return this;
        }

        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        public Builder planIds(String planIds) {
            this.planIds = Optional.of(Collections.singletonList(planIds));
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<String> action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @JsonSetter(value="base_plan_action", nulls=Nulls.SKIP)
        public Builder basePlanAction(Optional<String> basePlanAction) {
            this.basePlanAction = basePlanAction;
            return this;
        }

        public Builder basePlanAction(String basePlanAction) {
            this.basePlanAction = Optional.ofNullable(basePlanAction);
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListPlanChangesRequest build() {
            return new ListPlanChangesRequest(this.companyIds, this.planIds, this.action, this.basePlanAction, this.companyId, this.limit, this.offset, this.additionalProperties);
        }
    }
}

